/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackSlash {
    private static final char PRIVATE_BLOCK = '\ue000';
    public static final String BS_BS_N = "\\n";
    public static final String NEWLINE = "\n";
    public static final char CHAR_NEWLINE = '\n';

    public static char hiddenNewLine() {
        return '\ue00a';
    }

    public static String convertHiddenNewLine(String string) {
        string = string.replaceAll("(?<!\\\\)\\\\n", "" + BackSlash.hiddenNewLine());
        string = string.replaceAll("\\\\\\\\n", "\\\\n");
        return string;
    }

    public static List<String> splitHiddenNewLine(String string) {
        return Arrays.asList(string.split("" + BackSlash.hiddenNewLine()));
    }

    public static String manageNewLine(String string) {
        return string.replace(BackSlash.hiddenNewLine(), '\n');
    }

    public static List<String> getWithNewlines(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\' && i < charSequence.length() - 1) {
                char c2 = charSequence.charAt(i + 1);
                ++i;
                if (c2 == 'n') {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    continue;
                }
                if (c2 == 't') {
                    stringBuilder.append('\t');
                    continue;
                }
                if (c2 != '\\') continue;
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c);
        }
        arrayList.add(stringBuilder.toString());
        return Collections.unmodifiableList(arrayList);
    }

    public static String translateBackSlashes(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c == '\\' && i < charSequence.length() - 1 && BackSlash.isEnglishLetter(charSequence.charAt(i + 1))) {
                stringBuilder.append('\\');
                stringBuilder.append(BackSlash.translateChar(charSequence.charAt(i + 1)));
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String untranslateBackSlashes(CharSequence charSequence) {
        if (charSequence == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (c > '\ue000' && c < '\ue07f') {
                c = (char)(c - 57344);
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isEnglishLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    private static char translateChar(char c) {
        if (c > '\u0080') {
            throw new IllegalArgumentException();
        }
        return (char)(57344 + c);
    }
}

