/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Option;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileGroup {
    private final List<File> result = new ArrayList<File>();
    private final String pattern;
    private final List<String> excluded;
    private final Option option;
    private static final Pattern2 predirPath = MyPattern.cmpile("^([^*?]*[/\\\\])?(.*)$");
    private static final Pattern2 noStarInDirectory = MyPattern.cmpile("^(?:([^*?]*)[/\\\\])?([^/\\\\]*)$");

    public FileGroup(String string, List<String> list, Option option) {
        this.pattern = string;
        this.excluded = list;
        this.option = option;
        if (string.indexOf("*") == -1 && string.indexOf("?") == -1) {
            this.initNoStar();
        } else if (string.indexOf("**") != -1) {
            this.recurse();
        } else {
            this.initWithSimpleStar();
        }
        Collections.sort(this.result);
    }

    private void recurse() {
        Matcher2 matcher2 = predirPath.matcher(this.pattern);
        boolean bl = matcher2.find();
        if (!bl) {
            throw new IllegalArgumentException();
        }
        File file = matcher2.group(1) == null ? new File(".") : new File(matcher2.group(1));
        this.initWithDoubleStar(file);
    }

    private void initNoStar() {
        File file = new File(this.pattern);
        if (file.isDirectory()) {
            this.addSimpleDirectory(file);
        } else if (file.isFile()) {
            this.addResultFile(file);
        }
    }

    private void addResultFile(File file) {
        String string = FileGroup.getNormalizedPath(file);
        for (String string2 : this.excluded) {
            if (!string.matches(FileGroup.toRegexp(string2))) continue;
            return;
        }
        this.result.add(file);
    }

    private void addSimpleDirectory(File file) {
        if (OptionFlags.getInstance().isWord()) {
            this.addSimpleDirectory(file, "(?i)^.*_extr\\d+\\.txt$");
        } else {
            FileGroup fileGroup = this;
            this.addSimpleDirectory(file, fileGroup.option.getPattern());
        }
    }

    private void addSimpleDirectory(File file, String string) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("dir=" + file);
        }
        for (File file2 : file.listFiles()) {
            if (!file2.getName().matches(string)) continue;
            this.addResultFile(file2);
        }
    }

    private static String getNormalizedPath(File file) {
        return file.getPath().replace('\\', '/');
    }

    private void initWithSimpleStar() {
        assert (this.pattern.indexOf("**") == -1);
        Matcher2 matcher2 = noStarInDirectory.matcher(this.pattern);
        if (matcher2.find()) {
            String string;
            File file = new File(".");
            if (matcher2.group(1) != null) {
                string = matcher2.group(1);
                file = new File(string);
            }
            string = matcher2.group(2);
            this.addSimpleDirectory(file, FileGroup.toRegexp(string));
        } else {
            this.recurse();
        }
    }

    private void initWithDoubleStar(File file) {
        for (File file2 : file.listFiles()) {
            String string;
            if (file2.isDirectory()) {
                this.initWithDoubleStar(file2);
                continue;
            }
            if (!file2.isFile() || !(string = FileGroup.getNormalizedPath(file2)).matches(FileGroup.toRegexp(this.pattern))) continue;
            this.addResultFile(file2);
        }
    }

    public List<File> getFiles() {
        return Collections.unmodifiableList(this.result);
    }

    public static String toRegexp(String string) {
        string = string.replace("\\", "/");
        string = string.replace(".", "\\.");
        string = string.replace("?", "[^/]");
        string = string.replace("/**/", "(/|/.{0,}/)");
        string = string.replace("**", ".{0,}");
        string = string.replace("*", "[^/]{0,}");
        string = "(?i)^(\\./)?" + string + "$";
        return string;
    }
}

