/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystem {
    private static final FileSystem singleton = new FileSystem();
    private final ThreadLocal<File> currentDir = new ThreadLocal();

    private FileSystem() {
        this.reset();
    }

    public static FileSystem getInstance() {
        return singleton;
    }

    public void setCurrentDir(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        Log.info("Setting current dir: " + file);
        this.currentDir.set(file);
    }

    public File getCurrentDir() {
        return this.currentDir.get();
    }

    public File getFile(String string) throws IOException {
        File file;
        File file2 = this.currentDir.get();
        if (file2 == null || this.isAbsolute(string)) {
            return new File(string).getCanonicalFile();
        }
        File file3 = new File(file2.getAbsoluteFile(), string);
        if (file3.exists()) {
            return file3.getCanonicalFile();
        }
        for (File file4 : this.getPath("plantuml.include.path")) {
            file = new File(file4, string);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        for (File file4 : this.getPath("java.class.path")) {
            file = new File(file4, string);
            if (!file.exists()) continue;
            return file.getCanonicalFile();
        }
        return file3;
    }

    private List<File> getPath(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return arrayList;
        }
        string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, System.getProperty("path.separator"));
        while (stringTokenizer.hasMoreTokens()) {
            File file = new File(stringTokenizer.nextToken());
            if (!file.exists() || !file.isDirectory()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private boolean isAbsolute(String string) {
        File file = new File(string);
        return file.isAbsolute();
    }

    public void reset() {
        this.setCurrentDir(new File("."));
    }
}

