/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.FileImageData;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.NamedOutputStream;
import znaishaded.net.sourceforge.plantuml.NewpagedDiagram;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.SuggestedFile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import znaishaded.net.sourceforge.plantuml.png.PngSplitter;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemUtils {
    public static List<FileImageData> exportDiagrams(Diagram diagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        if (diagram instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)diagram, suggestedFile, fileFormatOption);
        }
        if (diagram instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)diagram, suggestedFile, fileFormatOption);
        }
        if (diagram instanceof CucaDiagram) {
            return PSystemUtils.exportDiagramsCuca((CucaDiagram)diagram, suggestedFile, fileFormatOption);
        }
        if (diagram instanceof ActivityDiagram3) {
            return PSystemUtils.exportDiagramsActivityDiagram3((ActivityDiagram3)diagram, suggestedFile, fileFormatOption);
        }
        return PSystemUtils.exportDiagramsDefault(diagram, suggestedFile, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsNewpaged(NewpagedDiagram newpagedDiagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<FileImageData> arrayList = new ArrayList<FileImageData>();
        int n = newpagedDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            Object var10_9;
            File file = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(file)) {
                return arrayList;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageData imageData = null;
            try {
                newpagedDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                ((OutputStream)bufferedOutputStream).close();
                throw throwable;
            }
            ((OutputStream)bufferedOutputStream).close();
            Log.info("File size : " + file.length());
            arrayList.add(new FileImageData(file, imageData));
        }
        return arrayList;
    }

    public static boolean canFileBeWritten(File file) {
        Log.info("Creating file: " + file);
        if (file.exists() && !file.canWrite()) {
            if (OptionFlags.getInstance().isOverwrite()) {
                Log.info("Overwrite " + file);
                file.setWritable(true);
                file.delete();
                return true;
            }
            Log.error("Cannot write to file " + file);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<FileImageData> exportDiagramsDefault(Diagram diagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ImageData imageData;
        OutputStream outputStream;
        block4: {
            List<FileImageData> list;
            if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
                throw new IllegalArgumentException("File is a directory " + suggestedFile);
            }
            outputStream = null;
            imageData = null;
            try {
                if (PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) break block4;
                list = Collections.emptyList();
                Object var7_6 = null;
                if (outputStream == null) return list;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return list;
        }
        outputStream = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
        imageData = diagram.exportDiagram(outputStream, 0, fileFormatOption);
        Object var7_7 = null;
        if (outputStream == null) return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData));
        outputStream.close();
        return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<FileImageData> exportDiagramsActivityDiagram3(ActivityDiagram3 activityDiagram3, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ImageData imageData;
        ImageData imageData2;
        OutputStream outputStream;
        block8: {
            List<FileImageData> list;
            block7: {
                if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
                    throw new IllegalArgumentException("File is a directory " + suggestedFile);
                }
                outputStream = null;
                imageData2 = null;
                imageData = null;
                try {
                    if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                        list = Collections.emptyList();
                        Object var8_7 = null;
                        if (outputStream == null) return list;
                        break block7;
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
                    imageData = imageData2 = activityDiagram3.exportDiagram(outputStream, 0, fileFormatOption);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
            }
            outputStream.close();
            return list;
        }
        Object var8_8 = null;
        if (outputStream != null) {
            outputStream.close();
        }
        if (imageData2 != null && imageData2.containsCMapData()) {
            activityDiagram3.exportCmap(suggestedFile, 0, imageData2);
        }
        return Arrays.asList(new FileImageData(suggestedFile.getFile(0), imageData));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<FileImageData> exportDiagramsSequence(SequenceDiagram sequenceDiagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<FileImageData> arrayList = new ArrayList<FileImageData>();
        int n = sequenceDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            Object var10_9;
            File file = suggestedFile.getFile(i);
            if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(i))) {
                return arrayList;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            ImageData imageData = null;
            try {
                imageData = sequenceDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                ((OutputStream)bufferedOutputStream).close();
                throw throwable;
            }
            ((OutputStream)bufferedOutputStream).close();
            if (imageData != null && imageData.containsCMapData()) {
                sequenceDiagram.exportCmap(suggestedFile, i, imageData);
            }
            Log.info("File size : " + file.length());
            arrayList.add(new FileImageData(file, imageData));
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<FileImageData> exportDiagramsCuca(CucaDiagram cucaDiagram, SuggestedFile suggestedFile, FileFormatOption fileFormatOption) throws IOException {
        OutputStream outputStream;
        ImageData imageData;
        block12: {
            List<FileImageData> list;
            block11: {
                if (suggestedFile.getFile(0).exists() && suggestedFile.getFile(0).isDirectory()) {
                    throw new IllegalArgumentException("File is a directory " + suggestedFile);
                }
                if (fileFormatOption.getFileFormat() == FileFormat.HTML) {
                    return PSystemUtils.createFilesHtml(cucaDiagram, suggestedFile);
                }
                imageData = null;
                outputStream = null;
                try {
                    if (!PSystemUtils.canFileBeWritten(suggestedFile.getFile(0))) {
                        list = Collections.emptyList();
                        Object var7_7 = null;
                        if (outputStream == null) return list;
                        break block11;
                    }
                    outputStream = new NamedOutputStream(suggestedFile.getFile(0));
                    imageData = cucaDiagram.exportDiagram(outputStream, 0, fileFormatOption);
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
            }
            outputStream.close();
            return list;
        }
        Iterator<File> iterator = null;
        if (outputStream != null) {
            outputStream.close();
        }
        List<File> list = Arrays.asList(suggestedFile.getFile(0));
        if (imageData != null && imageData.containsCMapData()) {
            cucaDiagram.exportCmap(suggestedFile, 0, imageData);
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PNG) {
            list = new PngSplitter(suggestedFile, cucaDiagram.getHorizontalPages(), cucaDiagram.getVerticalPages(), cucaDiagram.getMetadata(), cucaDiagram.getDpi(fileFormatOption), fileFormatOption.isWithMetadata(), cucaDiagram.getSkinParam().getSplitParam()).getFiles();
        }
        ArrayList<FileImageData> arrayList = new ArrayList<FileImageData>();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            arrayList.add(new FileImageData(file, imageData));
        }
        return arrayList;
    }

    private static List<FileImageData> createFilesHtml(CucaDiagram cucaDiagram, SuggestedFile suggestedFile) throws IOException {
        String string = suggestedFile.getName();
        int n = string.lastIndexOf(46);
        File file = new File(suggestedFile.getParentFile(), string.substring(0, n));
        CucaDiagramHtmlMaker cucaDiagramHtmlMaker = new CucaDiagramHtmlMaker(cucaDiagram, file);
        return cucaDiagramHtmlMaker.create();
    }
}

