/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.BlockUmlBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.NullOutputStream;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceStringReader {
    private final List<BlockUml> blocks;

    public SourceStringReader(String string) {
        this(Defines.createEmpty(), string, Collections.emptyList());
    }

    public SourceStringReader(String string, String string2) {
        this(Defines.createEmpty(), string, "UTF-8", Collections.emptyList());
    }

    public SourceStringReader(Defines defines, String string, List<String> list) {
        this(defines, string, "UTF-8", list);
    }

    public SourceStringReader(String string, File file) {
        this(Defines.createEmpty(), string, "UTF-8", Collections.emptyList(), file);
    }

    public SourceStringReader(Defines defines, String string, String string2, List<String> list) {
        this(defines, string, string2, list, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SourceStringReader(Defines defines, String string, String string2, List<String> list, File file) {
        Class<SourceStringReader> clazz = SourceStringReader.class;
        synchronized (SourceStringReader.class) {
            try {
                BlockUmlBuilder blockUmlBuilder = new BlockUmlBuilder(list, string2, defines, new StringReader(string), file, null);
                this.blocks = blockUmlBuilder.getBlockUmls();
            }
            catch (IOException iOException) {
                Log.error("error " + iOException);
                throw new IllegalStateException(iOException);
            }
            return;
        }
    }

    @Deprecated
    public String generateImage(OutputStream outputStream) throws IOException {
        return this.outputImage(outputStream).getDescription();
    }

    public DiagramDescription outputImage(OutputStream outputStream) throws IOException {
        return this.outputImage(outputStream, 0);
    }

    @Deprecated
    public String generateImage(File file) throws IOException {
        return this.outputImage(file).getDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiagramDescription outputImage(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        DiagramDescription diagramDescription = null;
        try {
            diagramDescription = this.outputImage((OutputStream)bufferedOutputStream, 0);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            ((OutputStream)bufferedOutputStream).close();
            throw throwable;
        }
        ((OutputStream)bufferedOutputStream).close();
        return diagramDescription;
    }

    @Deprecated
    public String generateImage(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(outputStream, fileFormatOption).getDescription();
    }

    public DiagramDescription outputImage(OutputStream outputStream, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(outputStream, 0, fileFormatOption);
    }

    @Deprecated
    public String generateImage(OutputStream outputStream, int n) throws IOException {
        return this.outputImage(outputStream, n).getDescription();
    }

    public DiagramDescription outputImage(OutputStream outputStream, int n) throws IOException {
        return this.outputImage(outputStream, n, new FileFormatOption(FileFormat.PNG));
    }

    @Deprecated
    public String generateImage(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        return this.outputImage(outputStream, n, fileFormatOption).getDescription();
    }

    public DiagramDescription outputImage(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            this.noStartumlFound(outputStream, fileFormatOption, 42L);
            return null;
        }
        for (BlockUml blockUml : this.blocks) {
            Diagram diagram = blockUml.getDiagram();
            int n2 = diagram.getNbImages();
            if (n < n2) {
                ImageData imageData = diagram.exportDiagram(outputStream, n, fileFormatOption);
                return diagram.getDescription();
            }
            n -= n2;
        }
        Log.error("numImage is too big = " + n);
        return null;
    }

    public DiagramDescription generateDiagramDescription(int n, FileFormatOption fileFormatOption) {
        if (this.blocks.size() == 0) {
            return null;
        }
        for (BlockUml blockUml : this.blocks) {
            Diagram diagram = blockUml.getDiagram();
            int n2 = diagram.getNbImages();
            if (n < n2) {
                return diagram.getDescription();
            }
            n -= n2;
        }
        Log.error("numImage is too big = " + n);
        return null;
    }

    public DiagramDescription generateDiagramDescription() {
        return this.generateDiagramDescription(0);
    }

    public DiagramDescription generateDiagramDescription(FileFormatOption fileFormatOption) {
        return this.generateDiagramDescription(0, fileFormatOption);
    }

    public DiagramDescription generateDiagramDescription(int n) {
        return this.generateDiagramDescription(n, new FileFormatOption(FileFormat.PNG));
    }

    public String getCMapData(int n, FileFormatOption fileFormatOption) throws IOException {
        if (this.blocks.size() == 0) {
            return null;
        }
        for (BlockUml blockUml : this.blocks) {
            Diagram diagram = blockUml.getDiagram();
            int n2 = diagram.getNbImages();
            if (n < n2) {
                ImageData imageData = diagram.exportDiagram(new NullOutputStream(), n, fileFormatOption);
                if (imageData.containsCMapData()) {
                    return imageData.getCMapData("plantuml");
                }
                return null;
            }
            n -= n2;
        }
        return null;
    }

    private void noStartumlFound(OutputStream outputStream, FileFormatOption fileFormatOption, long l) throws IOException {
        IEntityImage iEntityImage = GraphicStrings.createForError(Arrays.asList("No @startuml found"), fileFormatOption.isUseRedForError());
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, iEntityImage.getBackcolor(), null, null, 0.0, 0.0, null, false);
        imageBuilder.setUDrawable(iEntityImage);
        imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    public final List<BlockUml> getBlocks() {
        return Collections.unmodifiableList(this.blocks);
    }
}

