/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.imageio.ImageIO;
import javax.script.ScriptException;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.Annotated;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.FileUtils;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.PSystemUtils;
import znaishaded.net.sourceforge.plantuml.Pragma;
import znaishaded.net.sourceforge.plantuml.Scale;
import znaishaded.net.sourceforge.plantuml.SkinParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.SuggestedFile;
import znaishaded.net.sourceforge.plantuml.UmlDiagramType;
import znaishaded.net.sourceforge.plantuml.anim.Animation;
import znaishaded.net.sourceforge.plantuml.anim.AnimationDecoder;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.core.UmlSource;
import znaishaded.net.sourceforge.plantuml.cucadiagram.DisplayPositionned;
import znaishaded.net.sourceforge.plantuml.cucadiagram.UnparsableGraphvizException;
import znaishaded.net.sourceforge.plantuml.flashcode.FlashCodeFactory;
import znaishaded.net.sourceforge.plantuml.flashcode.FlashCodeUtils;
import znaishaded.net.sourceforge.plantuml.fun.IconLoader;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicPosition;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import znaishaded.net.sourceforge.plantuml.pdf.PdfConverter;
import znaishaded.net.sourceforge.plantuml.svek.EmptySvgException;
import znaishaded.net.sourceforge.plantuml.svek.GraphvizCrash;
import znaishaded.net.sourceforge.plantuml.svek.TextBlockBackcolored;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.sprite.Sprite;
import znaishaded.net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class UmlDiagram
extends AbstractPSystem
implements Diagram,
Annotated {
    private boolean rotation;
    private boolean hideUnlinkedData;
    private int minwidth = Integer.MAX_VALUE;
    private DisplayPositionned title = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.TOP);
    private DisplayPositionned caption = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositionned header = DisplayPositionned.none(HorizontalAlignment.RIGHT, VerticalAlignment.TOP);
    private DisplayPositionned footer = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private DisplayPositionned legend = DisplayPositionned.none(HorizontalAlignment.CENTER, VerticalAlignment.BOTTOM);
    private final Pragma pragma = new Pragma();
    private Scale scale;
    private Animation animation;
    private final SkinParam skinParam = SkinParam.create(this.getUmlDiagramType());
    private Dimension2D lastInfo;
    private boolean useJDot;

    public final void setTitle(DisplayPositionned displayPositionned) {
        this.title = displayPositionned;
    }

    public final void setCaption(DisplayPositionned displayPositionned) {
        this.caption = displayPositionned;
    }

    @Override
    public final DisplayPositionned getCaption() {
        return this.caption;
    }

    @Override
    public final DisplayPositionned getTitle() {
        return this.title;
    }

    public final int getMinwidth() {
        return this.minwidth;
    }

    public final void setMinwidth(int n) {
        this.minwidth = n;
    }

    public final boolean isRotation() {
        return this.rotation;
    }

    public final void setRotation(boolean bl) {
        this.rotation = bl;
    }

    public final ISkinParam getSkinParam() {
        return this.skinParam;
    }

    public void setParam(String string, String string2) {
        this.skinParam.setParam(StringUtils.goLowerCase(string), string2);
    }

    @Override
    public final DisplayPositionned getHeader() {
        return this.header;
    }

    public final void setHeader(DisplayPositionned displayPositionned) {
        this.header = displayPositionned;
    }

    @Override
    public final DisplayPositionned getFooter() {
        return this.footer;
    }

    public final void setFooter(DisplayPositionned displayPositionned) {
        this.footer = displayPositionned;
    }

    public final DisplayPositionned getFooterOrHeaderTeoz(FontParam fontParam) {
        if (fontParam == FontParam.FOOTER) {
            return this.getFooter();
        }
        if (fontParam == FontParam.HEADER) {
            return this.getHeader();
        }
        throw new IllegalArgumentException();
    }

    public abstract UmlDiagramType getUmlDiagramType();

    public Pragma getPragma() {
        return this.pragma;
    }

    public final void setScale(Scale scale) {
        this.scale = scale;
    }

    public final Scale getScale() {
        return this.scale;
    }

    public final void setAnimation(Iterable<CharSequence> iterable) {
        try {
            AnimationDecoder animationDecoder = new AnimationDecoder(iterable);
            this.animation = Animation.create(animationDecoder.decode());
        }
        catch (ScriptException scriptException) {
            scriptException.printStackTrace();
        }
    }

    public final Animation getAnimation() {
        return this.animation;
    }

    public final double getDpiFactor(FileFormatOption fileFormatOption) {
        if (this.getSkinParam().getDpi() == 96) {
            return 1.0;
        }
        return (double)this.getSkinParam().getDpi() / 96.0;
    }

    public final int getDpi(FileFormatOption fileFormatOption) {
        return this.getSkinParam().getDpi();
    }

    public final boolean isHideUnlinkedData() {
        return this.hideUnlinkedData;
    }

    public final void setHideUnlinkedData(boolean bl) {
        this.hideUnlinkedData = bl;
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream outputStream, int n, FileFormatOption fileFormatOption, long l) throws IOException {
        HtmlColor htmlColor = this.getSkinParam().getHoverPathColor();
        fileFormatOption = fileFormatOption.withSvgLinkTarget(this.getSkinParam().getSvgLinkTarget());
        if (htmlColor != null) {
            fileFormatOption = fileFormatOption.withHoverColor(StringUtils.getAsHtml(this.getSkinParam().getColorMapper().getMappedColor(htmlColor)));
        }
        if (fileFormatOption.getFileFormat() == FileFormat.PDF) {
            return this.exportDiagramInternalPdf(outputStream, n);
        }
        try {
            ImageData imageData = this.exportDiagramInternal(outputStream, n, fileFormatOption);
            this.lastInfo = new Dimension2DDouble(imageData.getWidth(), imageData.getHeight());
            return imageData;
        }
        catch (UnparsableGraphvizException unparsableGraphvizException) {
            unparsableGraphvizException.printStackTrace();
            this.exportDiagramError(outputStream, unparsableGraphvizException.getCause(), fileFormatOption, l, unparsableGraphvizException.getGraphvizVersion());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.exportDiagramError(outputStream, exception, fileFormatOption, l, null);
        }
        return new ImageDataSimple();
    }

    private void exportDiagramError(OutputStream outputStream, Throwable throwable, FileFormatOption fileFormatOption, long l, String string) throws IOException {
        UmlDiagram.exportDiagramError(outputStream, throwable, fileFormatOption, l, this.getMetadata(), this.getFlashData(), UmlDiagram.getFailureText1(throwable, string, this.getFlashData()));
    }

    public static void exportDiagramError(OutputStream outputStream, Throwable throwable, FileFormatOption fileFormatOption, long l, String string, String string2, List<String> list) throws IOException {
        if (fileFormatOption.getFileFormat() == FileFormat.ATXT || fileFormatOption.getFileFormat() == FileFormat.UTXT) {
            UmlDiagram.exportDiagramErrorText(outputStream, throwable, list);
            return;
        }
        list.addAll(CommandExecutionResult.getStackTrace(throwable));
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, HtmlColorUtils.WHITE, string, null, 0.0, 0.0, null, false);
        FlashCodeUtils flashCodeUtils = FlashCodeFactory.getFlashCodeUtils();
        final BufferedImage bufferedImage = flashCodeUtils.exportFlashcode(string2);
        if (bufferedImage != null) {
            GraphvizCrash.addDecodeHint(list);
        }
        final TextBlockBackcolored textBlockBackcolored = GraphicStrings.createBlackOnWhite(list, IconLoader.getRandom(), GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT);
        if (bufferedImage == null) {
            imageBuilder.setUDrawable(textBlockBackcolored);
        } else {
            imageBuilder.setUDrawable(new UDrawable(){

                public void drawU(UGraphic uGraphic) {
                    textBlockBackcolored.drawU(uGraphic);
                    double d = textBlockBackcolored.calculateDimension(uGraphic.getStringBounder()).getHeight();
                    uGraphic = uGraphic.apply(new UTranslate(0.0, d));
                    uGraphic.draw(new UImage(bufferedImage));
                }
            });
        }
        imageBuilder.writeImageTOBEMOVED(fileFormatOption, l, outputStream);
    }

    private static void exportDiagramErrorText(OutputStream outputStream, Throwable throwable, List<String> list) {
        PrintWriter printWriter = new PrintWriter(outputStream);
        throwable.printStackTrace(printWriter);
        printWriter.println();
        printWriter.println();
        for (String string : list) {
            string = string.replaceAll("\\</?\\w+?\\>", "");
            printWriter.println(string);
        }
        printWriter.flush();
    }

    public String getFlashData() {
        UmlSource umlSource = this.getSource();
        if (umlSource == null) {
            return "";
        }
        return umlSource.getPlainString();
    }

    private static List<String> getFailureText1(Throwable throwable, String string, String string2) {
        List<String> list = GraphvizCrash.anErrorHasOccured(throwable, string2);
        list.add("PlantUML (" + Version.versionString() + ") cannot parse result from dot/GraphViz.");
        if (throwable instanceof EmptySvgException) {
            list.add("Because dot/GraphViz returns an empty string.");
        }
        GraphvizCrash.checkOldVersionWarning(list);
        if (string != null) {
            list.add(" ");
            list.add("GraphViz version used : " + string);
        }
        GraphvizCrash.pleaseGoTo(list);
        GraphvizCrash.addProperties(list);
        list.add(" ");
        GraphvizCrash.thisMayBeCaused(list);
        list.add(" ");
        GraphvizCrash.youShouldSendThisDiagram(list);
        list.add(" ");
        return list;
    }

    public static List<String> getFailureText2(Throwable throwable, String string) {
        List<String> list = GraphvizCrash.anErrorHasOccured(throwable, string);
        list.add("PlantUML (" + Version.versionString() + ") has crashed.");
        GraphvizCrash.checkOldVersionWarning(list);
        list.add(" ");
        GraphvizCrash.youShouldSendThisDiagram(list);
        list.add(" ");
        return list;
    }

    private void exportDiagramInternalMjpeg(OutputStream outputStream) throws IOException {
        File file = new File("c:/test.avi");
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(file, 640, 480, 30.0, 150);
        for (int i = 0; i < 150; ++i) {
            AffineTransform affineTransform = new AffineTransform();
            double d = (double)(149 - i) * 1.0 / 150.0;
            affineTransform.setToShear(d, d);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.close();
            BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            mJPEGGenerator.addImage(bufferedImage);
        }
        mJPEGGenerator.finishAVI();
    }

    private ImageData exportDiagramInternalPdf(OutputStream outputStream, int n) throws IOException {
        File file = FileUtils.createTempFile("pdf", ".svf");
        File file2 = FileUtils.createTempFile("pdf", ".pdf");
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        ImageData imageData = this.exportDiagram(bufferedOutputStream, n, new FileFormatOption(FileFormat.SVG));
        ((OutputStream)bufferedOutputStream).close();
        PdfConverter.convert(file, file2);
        FileUtils.copyToStream(file2, outputStream);
        return imageData;
    }

    protected abstract ImageData exportDiagramInternal(OutputStream var1, int var2, FileFormatOption var3) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void exportCmap(SuggestedFile suggestedFile, int n, ImageData imageData) throws FileNotFoundException {
        String string = UmlDiagram.changeName(suggestedFile.getFile(n).getAbsolutePath());
        File file = new File(string);
        PrintWriter printWriter = null;
        try {
            if (!PSystemUtils.canFileBeWritten(file)) {
                return;
            }
            printWriter = new PrintWriter(file);
            printWriter.print(imageData.getCMapData(file.getName().substring(0, file.getName().length() - 6)));
            printWriter.close();
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
    }

    static String changeName(String string) {
        return string.replaceAll("(?i)\\.\\w{3}$", ".cmapx");
    }

    @Override
    public String getWarningOrError() {
        if (this.lastInfo == null) {
            return null;
        }
        double d = this.lastInfo.getWidth();
        if (d == 0.0) {
            return null;
        }
        String string = this.getSkinParam().getValue("widthwarning");
        if (string == null) {
            return null;
        }
        if (!string.matches("\\d+")) {
            return null;
        }
        int n = Integer.parseInt(string);
        if (d > (double)n) {
            return "The image is " + (int)d + " pixel width. (Warning limit is " + n + ")";
        }
        return null;
    }

    public void addSprite(String string, Sprite sprite) {
        this.skinParam.addSprite(string, sprite);
    }

    @Override
    public final DisplayPositionned getLegend() {
        return this.legend;
    }

    public final void setLegend(DisplayPositionned displayPositionned) {
        this.legend = displayPositionned;
    }

    public void setUseJDot(boolean bl) {
        this.useJDot = bl;
    }

    public boolean isUseJDot() {
        return this.useJDot;
    }

    public void setDotExecutable(String string) {
        this.skinParam.setDotExecutable(string);
    }
}

