/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.CreoleParser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileWithNoteOpale
extends AbstractFtile
implements Stencil {
    private final Ftile tile;
    private final Opale opale;
    private final NotePosition notePosition;
    private final double suppSpace = 20.0;
    private final Swimlane swimlaneNote;

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlaneNote != null) {
            HashSet<Swimlane> hashSet = new HashSet<Swimlane>(this.tile.getSwimlanes());
            hashSet.add(this.swimlaneNote);
            return Collections.unmodifiableSet(hashSet);
        }
        return this.tile.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.tile.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.tile.getSwimlaneOut();
    }

    @Override
    public Collection<Ftile> getMyChildren() {
        return Collections.singleton(this.tile);
    }

    public static Ftile create(Ftile ftile, Collection<PositionedNote> collection, ISkinParam iSkinParam, boolean bl) {
        if (collection.size() > 1) {
            return new FtileWithNotes(ftile, collection, iSkinParam);
        }
        if (collection.size() == 0) {
            throw new IllegalArgumentException();
        }
        return new FtileWithNoteOpale(ftile, collection.iterator().next(), iSkinParam, bl);
    }

    private FtileWithNoteOpale(Ftile ftile, PositionedNote positionedNote, ISkinParam iSkinParam, boolean bl) {
        super(ftile.skinParam());
        this.swimlaneNote = positionedNote.getSwimlaneNote();
        if (positionedNote.getColors() != null) {
            iSkinParam = positionedNote.getColors().mute(iSkinParam);
        }
        this.tile = ftile;
        this.notePosition = positionedNote.getNotePosition();
        if (positionedNote.getType() == NoteType.FLOATING_NOTE) {
            bl = false;
        }
        Rose rose = new Rose();
        HtmlColor htmlColor = rose.getHtmlColor(iSkinParam, ColorParam.noteBackground);
        HtmlColor htmlColor2 = rose.getHtmlColor(iSkinParam, ColorParam.noteBorder);
        FontConfiguration fontConfiguration = new FontConfiguration(iSkinParam, FontParam.NOTE, null);
        Sheet sheet = new CreoleParser(fontConfiguration, iSkinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), iSkinParam, CreoleMode.FULL).createSheet(positionedNote.getDisplay());
        SheetBlock2 sheetBlock2 = new SheetBlock2(new SheetBlock1(sheet, LineBreakStrategy.NONE, iSkinParam.getPadding()), this, new UStroke(1.0));
        this.opale = new Opale(htmlColor2, htmlColor, sheetBlock2, iSkinParam.shadowing(), bl);
    }

    private UTranslate getTranslate(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        Dimension2D dimension2D2 = this.opale.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        double d = (dimension2D.getHeight() - ((Dimension2D)ftileGeometry).getHeight()) / 2.0;
        double d2 = this.notePosition == NotePosition.LEFT ? dimension2D2.getWidth() + 20.0 : 0.0;
        return new UTranslate(d2, d);
    }

    private UTranslate getTranslateForOpale(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        FtileGeometry ftileGeometry = this.calculateDimension(stringBounder);
        Dimension2D dimension2D = this.opale.calculateDimension(stringBounder);
        double d = (((Dimension2D)ftileGeometry).getHeight() - dimension2D.getHeight()) / 2.0;
        if (this.notePosition == NotePosition.LEFT) {
            return new UTranslate(0.0, d);
        }
        double d2 = ((Dimension2D)ftileGeometry).getWidth() - dimension2D.getWidth();
        return new UTranslate(d2, d);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Swimlane swimlane = uGraphic instanceof UGraphicInterceptorOneSwimlane ? ((UGraphicInterceptorOneSwimlane)uGraphic).getSwimlane() : null;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.opale.calculateDimension(stringBounder);
        if (this.notePosition == NotePosition.LEFT) {
            Direction direction = Direction.RIGHT;
            Point2D.Double double_ = new Point2D.Double(dimension2D.getWidth(), dimension2D.getHeight() / 2.0);
            Point2D.Double double_2 = new Point2D.Double(dimension2D.getWidth() + 20.0, dimension2D.getHeight() / 2.0);
            this.opale.setOpale(direction, double_, double_2);
        } else {
            Direction direction = Direction.LEFT;
            Point2D.Double double_ = new Point2D.Double(0.0, dimension2D.getHeight() / 2.0);
            Point2D.Double double_3 = new Point2D.Double(-20.0, dimension2D.getHeight() / 2.0);
            this.opale.setOpale(direction, double_, double_3);
        }
        if (this.swimlaneNote == null || swimlane == this.swimlaneNote) {
            this.opale.drawU(uGraphic.apply(this.getTranslateForOpale(uGraphic)));
        }
        uGraphic.apply(this.getTranslate(stringBounder)).draw(this.tile);
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.calculateDimensionInternal(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        UTranslate uTranslate = this.getTranslate(stringBounder);
        if (ftileGeometry.hasPointOut()) {
            return new FtileGeometry(dimension2D, ftileGeometry.getLeft() + uTranslate.getDx(), ftileGeometry.getInY() + uTranslate.getDy(), ftileGeometry.getOutY() + uTranslate.getDy());
        }
        return new FtileGeometry(dimension2D, ftileGeometry.getLeft() + uTranslate.getDx(), ftileGeometry.getInY() + uTranslate.getDy());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimension2D = this.opale.calculateDimension(stringBounder);
        FtileGeometry ftileGeometry = this.tile.calculateDimension(stringBounder);
        double d = Math.max(dimension2D.getHeight(), ((Dimension2D)ftileGeometry).getHeight());
        return new Dimension2DDouble(((Dimension2D)ftileGeometry).getWidth() + 1.0 * dimension2D.getWidth() + 20.0, d);
    }

    @Override
    public double getStartingX(StringBounder stringBounder, double d) {
        return -this.opale.getMarginX1();
    }

    @Override
    public double getEndingX(StringBounder stringBounder, double d) {
        return this.opale.calculateDimension(stringBounder).getWidth() - (double)this.opale.getMarginX1();
    }
}

