/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ant;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.GeneratedImage;
import znaishaded.net.sourceforge.plantuml.Option;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.SourceFileReader;
import znaishaded.net.sourceforge.plantuml.Splash;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.stats.StatsUtils;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.DirectoryScanner;
import znaishaded.org.apache.tools.ant.Task;
import znaishaded.org.apache.tools.ant.types.FileList;
import znaishaded.org.apache.tools.ant.types.FileSet;

public class PlantUmlTask
extends Task {
    private String dir = null;
    private final Option option = new Option();
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private List<FileList> filelists = new ArrayList<FileList>();
    private AtomicInteger nbFiles = new AtomicInteger(0);
    private ExecutorService executorService;

    public void addFileset(FileSet fileSet) {
        this.filesets.add(fileSet);
    }

    public void addFilelist(FileList fileList) {
        this.filelists.add(fileList);
    }

    public void execute() throws BuildException {
        if (this.option.isSplash()) {
            Splash.createSplash();
        }
        this.log("Starting PlantUML");
        try {
            File file;
            if (this.dir != null) {
                Iterator<FileList> iterator = this.processingSingleDirectory(new File(this.dir));
                this.eventuallyFailfast((File)((Object)iterator));
            }
            for (FileSet dataType : this.filesets) {
                file = this.manageFileSet(dataType);
                this.eventuallyFailfast(file);
            }
            for (FileList fileList : this.filelists) {
                file = this.manageFileList(fileList);
                this.eventuallyFailfast(file);
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                this.executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
                if (this.option.isSplash()) {
                    Splash.disposeSplash();
                }
            }
            this.log("Nb images generated: " + this.nbFiles.get());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new BuildException(iOException.toString());
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new BuildException(interruptedException.toString());
        }
    }

    private void eventuallyFailfast(File file) throws IOException {
        if (file != null && this.option.isFailfastOrFailfast2()) {
            this.log("Error in file " + file.getCanonicalPath());
            throw new BuildException("Error in file " + file.getCanonicalPath());
        }
    }

    private File manageFileList(FileList fileList) throws IOException, InterruptedException {
        String[] stringArray;
        File file = fileList.getDir(this.getProject());
        for (String string : stringArray = fileList.getFiles(this.getProject())) {
            File file2 = new File(file, string);
            boolean bl = this.processingSingleFile(file2);
            if (!bl) continue;
            return file2;
        }
        return null;
    }

    private File manageFileSet(FileSet fileSet) throws IOException, InterruptedException {
        File file;
        DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(this.getProject());
        File file2 = fileSet.getDir(this.getProject());
        String[] stringArray = directoryScanner.getIncludedFiles();
        String[] stringArray2 = directoryScanner.getIncludedDirectories();
        for (String string : stringArray) {
            file = new File(file2, string);
            boolean bl = this.processingSingleFile(file);
            if (!bl) continue;
            return file;
        }
        for (String string : stringArray2) {
            file = new File(file2, string);
            File file3 = this.processingSingleDirectory(file);
            if (file3 == null) continue;
            return file3;
        }
        return null;
    }

    private boolean processingSingleFile(final File file) throws IOException, InterruptedException {
        if (OptionFlags.getInstance().isVerbose()) {
            this.log("Processing " + file.getAbsolutePath());
        }
        final SourceFileReader sourceFileReader = new SourceFileReader(Defines.createWithFileName(file), file, this.option.getOutputDir(), this.option.getConfig(), this.option.getCharset(), this.option.getFileFormatOption());
        if (this.option.isCheckOnly()) {
            return sourceFileReader.hasError();
        }
        if (this.executorService == null) {
            return this.doFile(file, sourceFileReader);
        }
        Splash.incTotal(1);
        this.executorService.submit(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return PlantUmlTask.this.doFile(file, sourceFileReader);
            }
        });
        return false;
    }

    private boolean doFile(File file, SourceFileReader sourceFileReader) throws IOException, InterruptedException {
        List<GeneratedImage> list = sourceFileReader.getGeneratedImages();
        boolean bl = false;
        for (GeneratedImage generatedImage : list) {
            if (OptionFlags.getInstance().isVerbose()) {
                this.myLog(generatedImage + " " + generatedImage.getDescription());
            }
            this.nbFiles.addAndGet(1);
            if (generatedImage.lineErrorRaw() == -1) continue;
            bl = true;
        }
        Splash.incDone(bl);
        if (bl) {
            this.myLog("Error: " + file.getCanonicalPath());
        }
        return bl && this.option.isFailfastOrFailfast2();
    }

    private synchronized void myLog(String string) {
        this.log(string);
    }

    private File processingSingleDirectory(File file) throws IOException, InterruptedException {
        if (!file.exists()) {
            String string = "The file " + file.getAbsolutePath() + " does not exists.";
            this.log(string);
            throw new BuildException(string);
        }
        for (File file2 : file.listFiles()) {
            boolean bl;
            if (!file2.isFile() || !this.fileToProcess(file2.getName()) || !(bl = this.processingSingleFile(file2))) continue;
            return file2;
        }
        return null;
    }

    private boolean fileToProcess(String string) {
        return string.matches(Option.getPattern());
    }

    public void setDir(String string) {
        this.dir = string;
    }

    public void setOutput(String string) {
        this.option.setOutputDir(new File(string));
    }

    public void setCharset(String string) {
        this.option.setCharset(string);
    }

    public void setConfig(String string) {
        try {
            this.option.initConfig(string);
        }
        catch (IOException iOException) {
            this.log("Error reading " + string);
        }
    }

    public void setKeepTmpFiles(String string) {
    }

    public void setDebugSvek(String string) {
        if ("true".equalsIgnoreCase(string)) {
            this.option.setDebugSvek(true);
        }
    }

    public void setVerbose(String string) {
        if ("true".equalsIgnoreCase(string)) {
            OptionFlags.getInstance().setVerbose(true);
        }
    }

    public void setFormat(String string) {
        if ("scxml".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SCXML));
        }
        if ("xmi".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STANDARD));
        }
        if ("xmi:argo".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_ARGO));
        }
        if ("xmi:start".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.XMI_STAR));
        }
        if ("eps".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS));
        }
        if ("braille".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.BRAILLE_PNG));
        }
        if ("pdf".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.PDF));
        }
        if ("latex".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.LATEX));
        }
        if ("latex:nopreamble".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.LATEX_NO_PREAMBLE));
        }
        if ("eps:text".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.EPS_TEXT));
        }
        if ("svg".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.SVG));
        }
        if ("txt".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.ATXT));
        }
        if ("utxt".equalsIgnoreCase(string)) {
            this.option.setFileFormatOption(new FileFormatOption(FileFormat.UTXT));
        }
    }

    public void setGraphvizDot(String string) {
        GraphvizUtils.setDotExecutable(string);
    }

    public void setNbThread(String string) {
        int n;
        if (string != null && string.matches("\\d+")) {
            this.option.setNbThreads(Integer.parseInt(string));
            n = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(n);
        }
        if ("auto".equalsIgnoreCase(string)) {
            this.option.setNbThreads(Option.defaultNbThreads());
            n = this.option.getNbThreads();
            this.executorService = Executors.newFixedThreadPool(n);
        }
    }

    public void setNbThreads(String string) {
        this.setNbThread(string);
    }

    public void setSuggestEngine(String string) {
        OptionFlags.getInstance().setUseSuggestEngine("true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string));
    }

    public void setFailFast(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        this.option.setFailfast(bl);
    }

    public void setFailFast2(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        this.option.setFailfast2(bl);
    }

    public void setCheckOnly(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        this.option.setCheckOnly(bl);
    }

    public void setOverwrite(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        OptionFlags.getInstance().setOverwrite(bl);
    }

    public void setFileSeparator(String string) {
        OptionFlags.getInstance().setFileSeparator(string);
    }

    public void setHtmlStats(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        StatsUtils.setHtmlStats(bl);
    }

    public void setXmlStats(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        StatsUtils.setXmlStats(bl);
    }

    public void setRealTimeStats(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        StatsUtils.setRealTimeStats(bl);
    }

    public void setEnableStats(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        OptionFlags.getInstance().setEnableStats(bl);
    }

    public void setSplash(String string) {
        boolean bl = "true".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "on".equalsIgnoreCase(string);
        this.option.setSplash(bl);
    }
}

