/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.bpm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.bpm.Chain;
import znaishaded.net.sourceforge.plantuml.bpm.Navigator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChainImpl<O>
implements Chain<O> {
    private final List<O> positive = new ArrayList<O>();
    private final List<O> negative = new ArrayList<O>();
    private int currentVersion;

    @Override
    public boolean remove(O o) {
        this.updateStructuralVersion();
        boolean bl = this.positive.remove(o);
        if (!bl) {
            bl = this.negative.remove(o);
        }
        return bl;
    }

    public ChainImpl<O> cloneMe() {
        ChainImpl<O> chainImpl = new ChainImpl<O>();
        chainImpl.currentVersion = this.currentVersion;
        chainImpl.positive.addAll(this.positive);
        chainImpl.negative.addAll(this.negative);
        return chainImpl;
    }

    @Override
    public int compare(O o, O o2) {
        if (o.equals(o2)) {
            return 0;
        }
        for (int i = this.negative.size() - 1; i >= 0; --i) {
            if (o.equals(this.negative.get(i))) {
                return -1;
            }
            if (!o2.equals(this.negative.get(i))) continue;
            return 1;
        }
        for (O o3 : this.positive) {
            if (o.equals(o3)) {
                return -1;
            }
            if (!o2.equals(o3)) continue;
            return 1;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List<O> toList() {
        ArrayList<O> arrayList = new ArrayList<O>();
        for (O o : this.negative) {
            if (o == null) continue;
            arrayList.add(0, o);
        }
        for (O o : this.positive) {
            if (o == null) continue;
            arrayList.add(o);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private ChainImpl() {
    }

    public ChainImpl(O o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.positive.add(o);
    }

    private int updateStructuralVersion() {
        ++this.currentVersion;
        return this.currentVersion;
    }

    @Override
    public boolean contains(O o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < Math.max(this.positive.size(), this.negative.size()); ++i) {
            if (i < this.positive.size() && o == this.positive.get(i)) {
                return true;
            }
            if (i >= this.negative.size() || o != this.negative.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Navigator<O> navigator(O o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < Math.max(this.positive.size(), this.negative.size()); ++i) {
            if (i < this.positive.size() && o == this.positive.get(i)) {
                InternalNavigator internalNavigator = new InternalNavigator(i, this.currentVersion);
                assert (internalNavigator.get() == o);
                return internalNavigator;
            }
            if (i >= this.negative.size() || o != this.negative.get(i)) continue;
            InternalNavigator internalNavigator = new InternalNavigator(-i - 1, this.currentVersion);
            assert (internalNavigator.get() == o);
            return internalNavigator;
        }
        throw new IllegalArgumentException();
    }

    private O getInternal(int n) {
        this.ensure(n);
        if (n >= 0) {
            return this.positive.get(n);
        }
        return this.negative.get(-n - 1);
    }

    private void setInternal(int n, O o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.ensure(n);
        if (n >= 0) {
            this.positive.set(n, o);
        } else {
            this.negative.set(-n - 1, o);
        }
    }

    private void insertInternal(int n, O o) {
        if (o == null) {
            throw new IllegalArgumentException();
        }
        this.ensure(n);
        if (n >= 0) {
            this.positive.add(n, o);
        } else {
            this.negative.add(-n - 1, o);
        }
    }

    private void ensure(int n) {
        if (n >= 0) {
            this.ensureInternal(n, this.positive);
        } else {
            this.ensureInternal(-n - 1, this.negative);
        }
    }

    private void ensureInternal(int n, List<O> list) {
        assert (n >= 0) : "position=" + n;
        while (list.size() <= n) {
            list.add(null);
        }
        assert (list.size() > n);
        assert (list.get(n) != this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InternalNavigator
    implements Navigator<O> {
        private int position = 0;
        private int version;

        private InternalNavigator(int n, int n2) {
            this.position = n;
            this.version = n2;
        }

        private void checkConsistency() {
            if (this.version != ChainImpl.this.currentVersion) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public O next() {
            this.checkConsistency();
            ++this.position;
            return this.get();
        }

        @Override
        public O previous() {
            this.checkConsistency();
            --this.position;
            return this.get();
        }

        @Override
        public O get() {
            this.checkConsistency();
            return ChainImpl.this.getInternal(this.position);
        }

        @Override
        public void set(O o) {
            this.checkConsistency();
            ChainImpl.this.setInternal(this.position, o);
        }

        @Override
        public void insertBefore(O o) {
            this.version = ChainImpl.this.updateStructuralVersion();
            ChainImpl.this.insertInternal(this.position, o);
        }

        @Override
        public void insertAfter(O o) {
            this.version = ChainImpl.this.updateStructuralVersion();
            ChainImpl.this.insertInternal(this.position + 1, o);
        }
    }
}

