/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SvgString;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSimple;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UImageSvg;

public class AtomMath
implements Atom {
    private final double scale;
    private final ScientificEquationSafe math;
    private final HtmlColor foreground;
    private final HtmlColor background;
    private Dimension2D dim;

    public AtomMath(ScientificEquationSafe scientificEquationSafe, HtmlColor htmlColor, HtmlColor htmlColor2, double d) {
        this.math = scientificEquationSafe;
        this.foreground = htmlColor;
        this.background = htmlColor2;
        this.scale = d;
    }

    private Dimension2D calculateDimensionSlow(StringBounder stringBounder) {
        BufferedImage bufferedImage = this.math.getImage(this.scale, Color.BLACK, Color.WHITE);
        return new Dimension2DDouble(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.dim == null) {
            this.dim = this.calculateDimensionSlow(stringBounder);
        }
        return this.dim;
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    public void drawU(UGraphic uGraphic) {
        boolean bl = uGraphic.matchesProperty("SVG");
        Color color = bl && this.background == null ? null : this.getColor(this.background == null ? uGraphic.getParam().getBackcolor() : this.background, Color.WHITE);
        Color color2 = this.getColor(this.foreground, Color.BLACK);
        if (bl) {
            SvgString svgString = this.math.getSvg(this.scale, color2, color);
            uGraphic.draw(new UImageSvg(svgString));
        } else {
            uGraphic.draw(new UImage(this.math.getImage(this.scale, color2, color)));
        }
    }

    private Color getColor(HtmlColor htmlColor, Color color) {
        if (htmlColor instanceof HtmlColorSimple) {
            return ((HtmlColorSimple)htmlColor).getColor999();
        }
        return color;
    }
}

