/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.geom.AbstractPolyline;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentInt;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.PolylineBreakeable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiderWeb {
    private final int pointsInCircle = 16;
    private int nbRow;
    private int nbCol;
    private final int widthCell;
    private final int heightCell;
    private final int xMargin = 50;
    private final int yMargin = 50;
    private final List<PolylineBreakeable> lines = new ArrayList<PolylineBreakeable>();

    public SpiderWeb(int n, int n2) {
        Log.info("widthCell=" + n + " heightCell=" + n2);
        this.widthCell = n;
        this.heightCell = n2;
    }

    public Point2DInt getMainPoint(int n, int n2) {
        return new Point2DInt(n2 * (this.widthCell + 50), n * (this.heightCell + 50));
    }

    public Collection<Point2DInt> getHangPoints(int n, int n2) {
        ArrayList<Point2DInt> arrayList = new ArrayList<Point2DInt>();
        int n3 = (int)Math.round(Math.sqrt(this.widthCell * this.widthCell + this.heightCell * this.heightCell) / 10.0);
        for (int i = 0; i < 16; ++i) {
            Point2DInt point2DInt = this.getMainPoint(n, n2);
            int n4 = point2DInt.getXint();
            int n5 = point2DInt.getYint();
            if (i == 0) {
                arrayList.add(new Point2DInt(n4 + n3, n5));
                continue;
            }
            if (i == 4) {
                arrayList.add(new Point2DInt(n4, n5 + n3));
                continue;
            }
            if (i == 8) {
                arrayList.add(new Point2DInt(n4 - n3, n5));
                continue;
            }
            if (i == 12) {
                arrayList.add(new Point2DInt(n4, n5 - n3));
                continue;
            }
            double d = Math.PI * 2 * (double)i / 16.0;
            double d2 = (double)n4 + (double)n3 * Math.cos(d);
            double d3 = (double)n5 + (double)n3 * Math.sin(d);
            arrayList.add(new Point2DInt((int)Math.round(d2), (int)Math.round(d3)));
        }
        return arrayList;
    }

    public PolylineBreakeable addPolyline(int n, int n2, int n3, int n4) {
        PolylineBreakeable polylineBreakeable = this.computePolyline(n, n2, n3, n4);
        if (polylineBreakeable != null) {
            this.lines.add(polylineBreakeable);
        }
        return polylineBreakeable;
    }

    private PolylineBreakeable computePolyline(int n, int n2, int n3, int n4) {
        PolylineBreakeable polylineBreakeable;
        if (n > this.nbRow) {
            this.nbRow = n;
        }
        if (n3 > this.nbRow) {
            this.nbRow = n3;
        }
        if (n2 > this.nbCol) {
            this.nbCol = n2;
        }
        if (n4 > this.nbCol) {
            this.nbCol = n4;
        }
        if (this.directLinkPossibleForGeometry(n, n2, n3, n4) && this.isCompatible(polylineBreakeable = new PolylineBreakeable(this.getMainPoint(n, n2), this.getMainPoint(n3, n4)))) {
            return polylineBreakeable;
        }
        return this.bestLevel1Line(n, n2, n3, n4);
    }

    private boolean isCompatible(PolylineBreakeable polylineBreakeable) {
        for (PolylineBreakeable polylineBreakeable2 : this.lines) {
            if (!polylineBreakeable2.doesTouch(polylineBreakeable)) continue;
            return false;
        }
        return true;
    }

    private PolylineBreakeable bestLevel1Line(int n, int n2, int n3, int n4) {
        AbstractPolyline abstractPolyline = null;
        for (int i = 5; i <= 95; i += 5) {
            for (int j = -200; j <= 200; j += 5) {
                PolylineBreakeable polylineBreakeable = new PolylineBreakeable(this.getMainPoint(n, n2), this.getMainPoint(n3, n4));
                polylineBreakeable.insertBetweenPoint(i, j);
                if (abstractPolyline != null && !(polylineBreakeable.getLength() < abstractPolyline.getLength()) || !this.isCompatible(polylineBreakeable)) continue;
                abstractPolyline = polylineBreakeable;
            }
        }
        return abstractPolyline;
    }

    boolean directLinkPossibleForGeometry(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        LineSegmentInt lineSegmentInt = new LineSegmentInt(n2, n, n4, n3);
        for (int i = n5; i <= n6; ++i) {
            for (int j = n7; j <= n8; ++j) {
                if (i == n && j == n2 || i == n3 && j == n4 || !lineSegmentInt.containsPoint(new Point2DInt(j, i))) continue;
                return false;
            }
        }
        return true;
    }

    final int getPointsInCircle() {
        return 16;
    }
}

