/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.geom.kinetic;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.Point2DCharge;
import znaishaded.net.sourceforge.plantuml.geom.kinetic.Quadrant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadrantMapper {
    private final Map<Point2DCharge, Quadrant> quadrants = new HashMap<Point2DCharge, Quadrant>();
    private final Map<Quadrant, HashSet<Point2DCharge>> setOfPoints = new HashMap<Quadrant, HashSet<Point2DCharge>>();

    public void addPoint(Point2DCharge point2DCharge) {
        if (this.quadrants.containsKey(point2DCharge)) {
            throw new IllegalArgumentException();
        }
        Quadrant quadrant = new Quadrant(point2DCharge);
        this.quadrants.put(point2DCharge, quadrant);
        this.getSetOfPoints(quadrant).add(point2DCharge);
        assert (this.getSetOfPoints(quadrant).contains(point2DCharge));
        assert (this.getSetOfPoints(new Quadrant(point2DCharge)).contains(point2DCharge));
    }

    public Set<Point2DCharge> getAllPoints(Quadrant quadrant) {
        return Collections.unmodifiableSet(this.getSetOfPoints(quadrant));
    }

    public Set<Point2DCharge> getAllPoints() {
        assert (this.quadrants.keySet().equals(this.mergeOfSetOfPoints()));
        return Collections.unmodifiableSet(this.quadrants.keySet());
    }

    private Set<Point2DCharge> mergeOfSetOfPoints() {
        HashSet<Point2DCharge> hashSet = new HashSet<Point2DCharge>();
        for (Set set : this.setOfPoints.values()) {
            assert (Collections.disjoint(set, hashSet));
            hashSet.addAll(set);
        }
        return hashSet;
    }

    public void updatePoint(Point2DCharge point2DCharge) {
        Quadrant quadrant = new Quadrant(point2DCharge);
        Quadrant quadrant2 = this.quadrants.get(point2DCharge);
        assert (this.getSetOfPoints(quadrant2).contains(point2DCharge));
        if (!quadrant2.equals(quadrant)) {
            assert (!this.getSetOfPoints(quadrant).contains(point2DCharge));
            assert (this.getSetOfPoints(quadrant2).contains(point2DCharge));
            boolean bl = this.getSetOfPoints(quadrant2).remove(point2DCharge);
            assert (bl);
            boolean bl2 = this.getSetOfPoints(quadrant).add(point2DCharge);
            assert (bl2);
            assert (this.getSetOfPoints(quadrant).contains(point2DCharge));
            assert (!this.getSetOfPoints(quadrant2).contains(point2DCharge));
            this.quadrants.put(point2DCharge, quadrant);
        }
        assert (this.getSetOfPoints(new Quadrant(point2DCharge)).contains(point2DCharge));
    }

    private HashSet<Point2DCharge> getSetOfPoints(Quadrant quadrant) {
        HashSet<Point2DCharge> hashSet = this.setOfPoints.get(quadrant);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.setOfPoints.put(quadrant, hashSet);
        }
        return hashSet;
    }
}

