/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.golem;

import znaishaded.net.sourceforge.plantuml.golem.TileGeometry;

public class Position {
    private final int xmin;
    private final int ymin;
    private final int xmax;
    private final int ymax;

    public Position(int n, int n2, int n3, int n4) {
        this.xmin = n;
        this.ymin = n2;
        this.xmax = n3;
        this.ymax = n4;
    }

    public boolean equals(Object object) {
        Position position = (Position)object;
        return this.xmin == position.xmin && this.xmax == position.xmax && this.ymin == position.ymin && this.ymax == position.ymax;
    }

    public int hashCode() {
        return this.xmin + this.ymin << 8 + this.xmax << 16 + this.ymax << 24;
    }

    public String toString() {
        return "(" + this.xmin + "," + this.ymin + ")-(" + this.xmax + "," + this.ymax + ")";
    }

    public Position move(TileGeometry tileGeometry, int n) {
        if (tileGeometry == null || tileGeometry == TileGeometry.CENTER) {
            throw new IllegalArgumentException();
        }
        switch (tileGeometry) {
            case NORTH: {
                return new Position(this.xmin, this.ymin - n, this.xmax, this.ymax - n);
            }
            case SOUTH: {
                return new Position(this.xmin, this.ymin + n, this.xmax, this.ymax + n);
            }
            case WEST: {
                return new Position(this.xmin - n, this.ymin, this.xmax - n, this.ymax);
            }
            case EAST: {
                return new Position(this.xmin + n, this.ymin, this.xmax + n, this.ymax);
            }
        }
        throw new IllegalStateException();
    }

    public int getXmin() {
        return this.xmin;
    }

    public int getXmax() {
        return this.xmax;
    }

    public int getYmin() {
        return this.ymin;
    }

    public int getYmax() {
        return this.ymax;
    }

    public int getCenterX() {
        if ((this.xmin + this.xmax + 1) % 2 != 0) {
            throw new IllegalStateException();
        }
        return (this.xmin + this.xmax + 1) / 2;
    }

    public int getCenterY() {
        if ((this.ymin + this.ymax + 1) % 2 != 0) {
            throw new IllegalStateException();
        }
        return (this.ymin + this.ymax + 1) / 2;
    }
}

