/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.graphic.FontChange;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorSet;

class ColorAndSizeChange
implements FontChange {
    static final Pattern2 colorPattern = MyPattern.cmpile("(?i)color\\s*=\\s*[%g]?(#[0-9a-fA-F]{6}|\\w+)[%g]?");
    static final Pattern2 sizePattern = MyPattern.cmpile("(?i)size\\s*=\\s*[%g]?(\\d+)[%g]?");
    private final HtmlColor color;
    private final Integer size;

    ColorAndSizeChange(String string) {
        Matcher2 matcher2 = colorPattern.matcher(string);
        this.color = matcher2.find() ? HtmlColorSet.getInstance().getColorIfValid(matcher2.group(1)) : null;
        Matcher2 matcher22 = sizePattern.matcher(string);
        this.size = matcher22.find() ? new Integer(matcher22.group(1)) : null;
    }

    HtmlColor getColor() {
        return this.color;
    }

    Integer getSize() {
        return this.size;
    }

    public FontConfiguration apply(FontConfiguration fontConfiguration) {
        FontConfiguration fontConfiguration2 = fontConfiguration;
        if (this.color != null) {
            fontConfiguration2 = fontConfiguration2.changeColor(this.color);
        }
        if (this.size != null) {
            fontConfiguration2 = fontConfiguration2.changeSize(this.size.intValue());
        }
        return fontConfiguration2;
    }
}

