/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlCommand;
import znaishaded.net.sourceforge.plantuml.graphic.ImgValign;
import znaishaded.net.sourceforge.plantuml.graphic.Text;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TileImage;
import znaishaded.net.sourceforge.plantuml.graphic.TileImageSvg;

public class Img
implements HtmlCommand {
    private static final Pattern2 srcPattern = MyPattern.cmpile("(?i)src[%s]*=[%s]*[\"%q]?([^%s\">]+)[\"%q]?");
    private static final Pattern2 vspacePattern = MyPattern.cmpile("(?i)vspace[%s]*=[%s]*[\"%q]?(\\d+)[\"%q]?");
    private static final Pattern2 valignPattern = MyPattern.cmpile("(?i)valign[%s]*=[%s]*[\"%q]?(top|bottom|middle)[\"%q]?");
    private static final Pattern2 noSrcColonPattern = MyPattern.cmpile("(?i)\\<img[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>");
    private final TextBlock tileImage;

    private Img(TextBlock textBlock) {
        this.tileImage = textBlock;
    }

    static int getVspace(String string) {
        Matcher2 matcher2 = vspacePattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return Integer.parseInt(matcher2.group(1));
    }

    static ImgValign getValign(String string) {
        Matcher2 matcher2 = valignPattern.matcher(string);
        if (!matcher2.find()) {
            return ImgValign.TOP;
        }
        return ImgValign.valueOf(StringUtils.goUpperCase(matcher2.group(1)));
    }

    static HtmlCommand getInstance(String string, boolean bl) {
        if (bl) {
            Matcher2 matcher2 = srcPattern.matcher(string);
            int n = Img.getVspace(string);
            ImgValign imgValign = Img.getValign(string);
            return Img.build(matcher2, imgValign, n);
        }
        Matcher2 matcher2 = noSrcColonPattern.matcher(string);
        return Img.build(matcher2, ImgValign.TOP, 0);
    }

    private static HtmlCommand build(Matcher2 matcher2, ImgValign imgValign, int n) {
        if (!matcher2.find()) {
            return new Text("(SYNTAX ERROR)");
        }
        String string = matcher2.group(1);
        try {
            File file = FileSystem.getInstance().getFile(string);
            if (!file.exists()) {
                if (string.startsWith("http:") || string.startsWith("https:")) {
                    byte[] byArray = Img.getFile(string);
                    BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(byArray));
                    if (bufferedImage == null) {
                        return new Text("(Cannot decode: " + string + ")");
                    }
                    return new Img(new TileImage(bufferedImage, imgValign, n));
                }
                return new Text("(File not found: " + file + ")");
            }
            if (file.getName().endsWith(".svg")) {
                return new Img(new TileImageSvg(file));
            }
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage == null) {
                return new Text("(Cannot decode: " + file + ")");
            }
            return new Img(new TileImage(ImageIO.read(file), imgValign, n));
        }
        catch (IOException iOException) {
            return new Text("ERROR " + iOException.toString());
        }
    }

    public TextBlock createMonoImage() {
        return this.tileImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static byte[] getFile(String string) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = null;
        try {
            int n;
            URL uRL = new URL(string);
            URLConnection uRLConnection = uRL.openConnection();
            inputStream = uRLConnection.getInputStream();
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) > 0) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.close();
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            return byArray2;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

