/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.EmbededDiagram;
import znaishaded.net.sourceforge.plantuml.SpriteContainer;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.EmbededSystemLine;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.Line;
import znaishaded.net.sourceforge.plantuml.graphic.SingleLine;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextBlockSimple
extends AbstractTextBlock
implements TextBlock {
    private List<Line> lines2;
    private final Display texts;
    private final FontConfiguration fontConfiguration;
    private final UFont fontForStereotype;
    private final HorizontalAlignment horizontalAlignment;
    private final SpriteContainer spriteContainer;
    private final double maxMessageSize;
    private final HtmlColor htmlColorForStereotype;

    protected TextBlockSimple(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, double d) {
        this(display, fontConfiguration, horizontalAlignment, spriteContainer, d, null, null);
    }

    public TextBlockSimple(Display display, FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer, double d, UFont uFont, HtmlColor htmlColor) {
        this.texts = display;
        this.fontConfiguration = fontConfiguration;
        this.horizontalAlignment = horizontalAlignment;
        this.spriteContainer = spriteContainer;
        this.maxMessageSize = d;
        this.fontForStereotype = uFont;
        this.htmlColorForStereotype = htmlColor;
    }

    private List<Line> getLines(StringBounder stringBounder) {
        if (this.lines2 == null) {
            if (stringBounder == null) {
                throw new IllegalStateException();
            }
            this.lines2 = new ArrayList<Line>();
            for (CharSequence charSequence : this.texts) {
                if (charSequence instanceof Stereotype) {
                    this.lines2.addAll(this.createLinesForStereotype(this.fontConfiguration.forceFont(this.fontForStereotype, this.htmlColorForStereotype), (Stereotype)charSequence, this.horizontalAlignment, this.spriteContainer));
                    continue;
                }
                if (charSequence instanceof EmbededDiagram) {
                    this.lines2.add(new EmbededSystemLine((EmbededDiagram)charSequence));
                    continue;
                }
                this.addInLines(stringBounder, charSequence.toString());
            }
        }
        return this.lines2;
    }

    private void addInLines(StringBounder stringBounder, String string) {
        if (this.maxMessageSize == 0.0) {
            this.addSingleLine(string);
        } else if (this.maxMessageSize > 0.0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ", true);
            StringBuilder stringBuilder = new StringBuilder();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                double d = this.getTextWidth(stringBounder, stringBuilder + string2);
                if (d > this.maxMessageSize) {
                    this.addSingleLineNoSpace(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    if (string2.startsWith(" ")) continue;
                    stringBuilder.append(string2);
                    continue;
                }
                stringBuilder.append(string2);
            }
            this.addSingleLineNoSpace(stringBuilder.toString());
        } else if (this.maxMessageSize < 0.0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                double d = this.getTextWidth(stringBounder, stringBuilder.toString() + c);
                if (d > -this.maxMessageSize) {
                    this.addSingleLineNoSpace(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    if (c == ' ') continue;
                    stringBuilder.append(c);
                    continue;
                }
                stringBuilder.append(c);
            }
            this.addSingleLineNoSpace(stringBuilder.toString());
        }
    }

    private void addSingleLineNoSpace(String string) {
        if (string.length() == 0 || MyPattern.mtches(string, "^[%s]*$ ")) {
            return;
        }
        this.lines2.add(new SingleLine(string, this.fontConfiguration, this.horizontalAlignment, this.spriteContainer));
    }

    private void addSingleLine(String string) {
        this.lines2.add(new SingleLine(string, this.fontConfiguration, this.horizontalAlignment, this.spriteContainer));
    }

    private double getTextWidth(StringBounder stringBounder, String string) {
        SingleLine singleLine = new SingleLine(string, this.fontConfiguration, this.horizontalAlignment, this.spriteContainer);
        return singleLine.calculateDimension(stringBounder).getWidth();
    }

    private List<SingleLine> createLinesForStereotype(FontConfiguration fontConfiguration, Stereotype stereotype, HorizontalAlignment horizontalAlignment, SpriteContainer spriteContainer) {
        assert (stereotype.getLabel(false) != null);
        ArrayList<SingleLine> arrayList = new ArrayList<SingleLine>();
        for (String string : stereotype.getLabels(spriteContainer.useGuillemet())) {
            arrayList.add(new SingleLine(string, fontConfiguration, horizontalAlignment, spriteContainer));
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.getTextDimension(stringBounder);
    }

    protected final Dimension2D getTextDimension(StringBounder stringBounder) {
        double d = 0.0;
        double d2 = 0.0;
        for (Line line : this.getLines(stringBounder)) {
            Dimension2D dimension2D = line.calculateDimension(stringBounder);
            d2 += dimension2D.getHeight();
            d = Math.max(d, dimension2D.getWidth());
        }
        return new Dimension2DDouble(d, d2);
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        double d = 0.0;
        Dimension2D dimension2D = this.getTextDimension(uGraphic.getStringBounder());
        for (Line line : this.getLines(uGraphic.getStringBounder())) {
            double d2;
            HorizontalAlignment horizontalAlignment = line.getHorizontalAlignment();
            double d3 = 0.0;
            if (horizontalAlignment == HorizontalAlignment.CENTER) {
                d2 = dimension2D.getWidth() - line.calculateDimension(uGraphic.getStringBounder()).getWidth();
                d3 = d2 / 2.0;
            } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
                d3 = d2 = dimension2D.getWidth() - line.calculateDimension(uGraphic.getStringBounder()).getWidth();
            }
            line.drawU(uGraphic.apply(new UTranslate(d3, d)));
            d += line.calculateDimension(uGraphic.getStringBounder()).getHeight();
        }
    }
}

