/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SkinParameter;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolActor;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolArtifact;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolBoundary;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolCard;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolCloud;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolComponent1;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolComponent2;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolControl;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolDatabase;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolEntityDomain;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFile;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFolder;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFrame;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolInterface;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolNode;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolQueue;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolRect;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolStack;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolStorage;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolTogether;

public abstract class USymbol {
    private static final Map<String, USymbol> all = new HashMap<String, USymbol>();
    public static final USymbol STORAGE = USymbol.record("STORAGE", SkinParameter.STORAGE, new USymbolStorage());
    public static final USymbol DATABASE = USymbol.record("DATABASE", SkinParameter.DATABASE, new USymbolDatabase());
    public static final USymbol CLOUD = USymbol.record("CLOUD", SkinParameter.CLOUD, new USymbolCloud());
    public static final USymbol CARD = USymbol.record("CARD", SkinParameter.CARD, new USymbolCard(SkinParameter.CARD));
    public static final USymbol FRAME = USymbol.record("FRAME", SkinParameter.FRAME, new USymbolFrame());
    public static final USymbol NODE = USymbol.record("NODE", SkinParameter.NODE, new USymbolNode());
    public static final USymbol ARTIFACT = USymbol.record("ARTIFACT", SkinParameter.ARTIFACT, new USymbolArtifact());
    public static final USymbol PACKAGE = USymbol.record("PACKAGE", SkinParameter.PACKAGE, new USymbolFolder(SkinParameter.PACKAGE));
    public static final USymbol FOLDER = USymbol.record("FOLDER", SkinParameter.FOLDER, new USymbolFolder(SkinParameter.FOLDER));
    public static final USymbol FILE = USymbol.record("FILE", SkinParameter.FILE, new USymbolFile());
    public static final USymbol RECTANGLE = USymbol.record("RECTANGLE", SkinParameter.RECTANGLE, new USymbolRect(SkinParameter.RECTANGLE, HorizontalAlignment.CENTER));
    public static final USymbol AGENT = USymbol.record("AGENT", SkinParameter.AGENT, new USymbolRect(SkinParameter.AGENT, HorizontalAlignment.CENTER));
    public static final USymbol ACTOR = USymbol.record("ACTOR", SkinParameter.ACTOR, new USymbolActor());
    public static final USymbol USECASE = null;
    public static final USymbol COMPONENT1 = USymbol.record("COMPONENT1", SkinParameter.COMPONENT1, new USymbolComponent1());
    public static final USymbol COMPONENT2 = USymbol.record("COMPONENT2", SkinParameter.COMPONENT2, new USymbolComponent2());
    public static final USymbol BOUNDARY = USymbol.record("BOUNDARY", SkinParameter.BOUNDARY, new USymbolBoundary());
    public static final USymbol ENTITY_DOMAIN = USymbol.record("ENTITY_DOMAIN", SkinParameter.ENTITY_DOMAIN, new USymbolEntityDomain(2.0));
    public static final USymbol CONTROL = USymbol.record("CONTROL", SkinParameter.CONTROL, new USymbolControl(2.0));
    public static final USymbol INTERFACE = USymbol.record("INTERFACE", SkinParameter.INTERFACE, new USymbolInterface());
    public static final USymbol QUEUE = USymbol.record("QUEUE", SkinParameter.QUEUE, new USymbolQueue());
    public static final USymbol STACK = USymbol.record("STACK", SkinParameter.STACK, new USymbolStack());
    public static final USymbol TOGETHER = USymbol.record("TOGETHER", SkinParameter.QUEUE, new USymbolTogether());

    public abstract SkinParameter getSkinParameter();

    public USymbol withStereoAlignment(HorizontalAlignment horizontalAlignment) {
        return this;
    }

    public FontParam getFontParam() {
        return this.getSkinParameter().getFontParam();
    }

    public FontParam getFontParamStereotype() {
        return this.getSkinParameter().getFontParamStereotype();
    }

    public ColorParam getColorParamBack() {
        return this.getSkinParameter().getColorParamBack();
    }

    public ColorParam getColorParamBorder() {
        return this.getSkinParameter().getColorParamBorder();
    }

    public static USymbol getFromString(String string) {
        if (string == null) {
            return null;
        }
        USymbol uSymbol = all.get(StringUtils.goUpperCase(string.replaceAll("\\W", "")));
        if (uSymbol == null) {
            if (string.equalsIgnoreCase("component")) {
                return COMPONENT2;
            }
            if (string.equalsIgnoreCase("entity")) {
                return ENTITY_DOMAIN;
            }
            return null;
        }
        return uSymbol;
    }

    private static USymbol record(String string, SkinParameter skinParameter, USymbol uSymbol) {
        all.put(StringUtils.goUpperCase(string), uSymbol);
        return uSymbol;
    }

    public abstract TextBlock asSmall(TextBlock var1, TextBlock var2, TextBlock var3, SymbolContext var4);

    public abstract TextBlock asBig(TextBlock var1, TextBlock var2, double var3, double var5, SymbolContext var7);

    public boolean manageHorizontalLine() {
        return false;
    }

    public int suppHeightBecauseOfShape() {
        return 0;
    }

    public int suppWidthBecauseOfShape() {
        return 0;
    }

    final Stencil getRectangleStencil(final Dimension2D dimension2D) {
        return new Stencil(){

            public double getStartingX(StringBounder stringBounder, double d) {
                return 0.0;
            }

            public double getEndingX(StringBounder stringBounder, double d) {
                return dimension2D.getWidth();
            }
        };
    }

    public static USymbol getFromString(String string, boolean bl) {
        USymbol uSymbol = null;
        if (string.equalsIgnoreCase("artifact")) {
            uSymbol = ARTIFACT;
        } else if (string.equalsIgnoreCase("folder")) {
            uSymbol = FOLDER;
        } else if (string.equalsIgnoreCase("file")) {
            uSymbol = FILE;
        } else if (string.equalsIgnoreCase("package")) {
            uSymbol = PACKAGE;
        } else if (string.equalsIgnoreCase("rectangle")) {
            uSymbol = RECTANGLE;
        } else if (string.equalsIgnoreCase("node")) {
            uSymbol = NODE;
        } else if (string.equalsIgnoreCase("frame")) {
            uSymbol = FRAME;
        } else if (string.equalsIgnoreCase("cloud")) {
            uSymbol = CLOUD;
        } else if (string.equalsIgnoreCase("database")) {
            uSymbol = DATABASE;
        } else if (string.equalsIgnoreCase("queue")) {
            uSymbol = QUEUE;
        } else if (string.equalsIgnoreCase("stack")) {
            uSymbol = STACK;
        } else if (string.equalsIgnoreCase("storage")) {
            uSymbol = STORAGE;
        } else if (string.equalsIgnoreCase("agent")) {
            uSymbol = AGENT;
        } else if (string.equalsIgnoreCase("actor")) {
            uSymbol = ACTOR;
        } else if (string.equalsIgnoreCase("component")) {
            uSymbol = bl ? COMPONENT2 : COMPONENT1;
        } else if (string.equalsIgnoreCase("boundary")) {
            uSymbol = BOUNDARY;
        } else if (string.equalsIgnoreCase("control")) {
            uSymbol = CONTROL;
        } else if (string.equalsIgnoreCase("entity")) {
            uSymbol = ENTITY_DOMAIN;
        } else if (string.equalsIgnoreCase("card")) {
            uSymbol = CARD;
        } else if (string.equalsIgnoreCase("interface")) {
            uSymbol = INTERFACE;
        } else if (string.equalsIgnoreCase("()")) {
            uSymbol = INTERFACE;
        }
        return uSymbol;
    }

    static class Margin {
        private final double x1;
        private final double x2;
        private final double y1;
        private final double y2;

        Margin(double d, double d2, double d3, double d4) {
            this.x1 = d;
            this.x2 = d2;
            this.y1 = d3;
            this.y2 = d4;
        }

        double getWidth() {
            return this.x1 + this.x2;
        }

        double getHeight() {
            return this.y1 + this.y2;
        }

        public Dimension2D addDimension(Dimension2D dimension2D) {
            return new Dimension2DDouble(dimension2D.getWidth() + this.x1 + this.x2, dimension2D.getHeight() + this.y1 + this.y2);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }
    }
}

