/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.SkinParameter;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

class USymbolFile
extends USymbol {
    private final HorizontalAlignment stereotypeAlignement = HorizontalAlignment.CENTER;

    USymbolFile() {
    }

    public SkinParameter getSkinParameter() {
        return SkinParameter.FILE;
    }

    private void drawFile(UGraphic uGraphic, double d, double d2, boolean bl) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(d, 10.0);
        uPolygon.addPoint(d - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.draw(uPolygon);
        UPath uPath = new UPath();
        uPath.moveTo(d - 10.0, 0.0);
        uPath.lineTo(d - 10.0, 10.0);
        uPath.lineTo(d, 10.0);
        uGraphic.draw(uPath);
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    public TextBlock asSmall(TextBlock textBlock, final TextBlock textBlock2, final TextBlock textBlock3, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = UGraphicStencil.create(uGraphic, USymbolFile.this.getRectangleStencil(dimension2D), new UStroke());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolFile.this.drawFile(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                USymbol.Margin margin = USymbolFile.this.getMargin();
                TextBlock textBlock = TextBlockUtils.mergeTB(textBlock3, textBlock2, HorizontalAlignment.CENTER);
                textBlock.drawU(uGraphic.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                Dimension2D dimension2D = textBlock2.calculateDimension(stringBounder);
                Dimension2D dimension2D2 = textBlock3.calculateDimension(stringBounder);
                return USymbolFile.this.getMargin().addDimension(Dimension2DDouble.mergeTB(dimension2D2, dimension2D));
            }
        };
    }

    public TextBlock asBig(final TextBlock textBlock, final TextBlock textBlock2, final double d, final double d2, final SymbolContext symbolContext) {
        return new AbstractTextBlock(){

            public void drawU(UGraphic uGraphic) {
                double d4;
                double d22;
                Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
                uGraphic = symbolContext.apply(uGraphic);
                USymbolFile.this.drawFile(uGraphic, dimension2D.getWidth(), dimension2D.getHeight(), symbolContext.isShadowing());
                Dimension2D dimension2D2 = textBlock2.calculateDimension(uGraphic.getStringBounder());
                if (USymbolFile.this.stereotypeAlignement == HorizontalAlignment.RIGHT) {
                    d22 = d - dimension2D2.getWidth() - USymbolFile.this.getMargin().getX1() / 2.0;
                    d4 = USymbolFile.this.getMargin().getY1() / 2.0;
                } else {
                    d22 = (d - dimension2D2.getWidth()) / 2.0;
                    d4 = 2.0;
                }
                textBlock2.drawU(uGraphic.apply(new UTranslate(d22, d4)));
                Dimension2D dimension2D3 = textBlock.calculateDimension(uGraphic.getStringBounder());
                double d3 = (d - dimension2D3.getWidth()) / 2.0;
                textBlock.drawU(uGraphic.apply(new UTranslate(d3, 2.0 + dimension2D2.getHeight())));
            }

            public Dimension2D calculateDimension(StringBounder stringBounder) {
                return new Dimension2DDouble(d, d2);
            }
        };
    }

    public boolean manageHorizontalLine() {
        return true;
    }
}

