/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.objectdiagram;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.NoteLinkStrategy;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassOrObjectDiagram
extends AbstractEntityDiagram {
    private final List<Association> associations = new ArrayList<Association>();

    public final boolean insertBetween(IEntity iEntity, IEntity iEntity2, IEntity iEntity3) {
        Link link = this.foundLink(iEntity, iEntity2);
        if (link == null) {
            return false;
        }
        Link link2 = new Link(iEntity, iEntity3, link.getType(), link.getLabel(), link.getLength(), link.getQualifier1(), null, link.getLabeldistance(), link.getLabelangle());
        Link link3 = new Link(iEntity3, iEntity2, link.getType(), link.getLabel(), link.getLength(), null, link.getQualifier2(), link.getLabeldistance(), link.getLabelangle());
        this.addLink(link2);
        this.addLink(link3);
        this.removeLink(link);
        return true;
    }

    private Link foundLink(IEntity iEntity, IEntity iEntity2) {
        List<Link> list = this.getLinks();
        for (int i = list.size() - 1; i >= 0; --i) {
            Link link = list.get(i);
            if (!link.isBetween(iEntity, iEntity2)) continue;
            return link;
        }
        return null;
    }

    public int getNbOfHozizontalLollipop(IEntity iEntity) {
        if (iEntity.getLeafType() == LeafType.LOLLIPOP) {
            throw new IllegalArgumentException();
        }
        int n = 0;
        for (Link link : this.getLinks()) {
            if (link.getLength() != 1 || !link.contains(iEntity) || !link.containsType(LeafType.LOLLIPOP)) continue;
            ++n;
        }
        return n;
    }

    public CommandExecutionResult associationClass(Code code, Code code2, Code code3, Code code4, LinkType linkType, Display display) {
        IEntity iEntity = this.getOrCreateLeaf(code, null, null);
        IEntity iEntity2 = this.getOrCreateLeaf(code2, null, null);
        IEntity iEntity3 = this.getOrCreateLeaf(code3, null, null);
        IEntity iEntity4 = this.getOrCreateLeaf(code4, null, null);
        List<Association> list = this.getExistingAssociatedPoints(iEntity, iEntity2);
        List<Association> list2 = this.getExistingAssociatedPoints(iEntity3, iEntity4);
        if (list.size() == 0 && list2.size() == 0) {
            IEntity iEntity5 = this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
            IEntity iEntity6 = this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
            this.insertPointBetween(iEntity, iEntity2, iEntity5);
            this.insertPointBetween(iEntity3, iEntity4, iEntity6);
            Link link = new Link(iEntity5, iEntity6, linkType, display, 1);
            this.addLink(link);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot link two associations points");
    }

    private void insertPointBetween(IEntity iEntity, IEntity iEntity2, IEntity iEntity3) {
        Link link = this.foundLink(iEntity, iEntity2);
        if (link == null) {
            link = new Link(iEntity, iEntity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
        } else {
            this.removeLink(link);
        }
        IEntity iEntity4 = link.isInverted() ? link.getEntity2() : link.getEntity1();
        IEntity iEntity5 = link.isInverted() ? link.getEntity1() : link.getEntity2();
        Link link2 = new Link(iEntity4, iEntity3, link.getType().getPart2(), link.getLabel(), link.getLength(), link.getQualifier1(), null, link.getLabeldistance(), link.getLabelangle());
        link2.setLinkArrow(link.getLinkArrow());
        Link link3 = new Link(iEntity3, iEntity5, link.getType().getPart1(), Display.NULL, link.getLength(), null, link.getQualifier2(), link.getLabeldistance(), link.getLabelangle());
        this.addLink(link2);
        this.addLink(link3);
    }

    public boolean associationClass(int n, Code code, Code code2, IEntity iEntity, LinkType linkType, Display display) {
        IEntity iEntity2;
        IEntity iEntity3 = this.getOrCreateLeaf(code, null, null);
        List<Association> list = this.getExistingAssociatedPoints(iEntity3, iEntity2 = this.getOrCreateLeaf(code2, null, null));
        if (list.size() > 1) {
            return false;
        }
        if (list.size() == 0) {
            Association association = new Association(n, iEntity3, iEntity2, iEntity);
            association.createNew(n, linkType, display);
            this.associations.add(association);
            return true;
        }
        assert (list.size() == 1);
        Association association = list.get(0).createSecondAssociation(n, iEntity, display);
        association.createInSecond(linkType, display);
        this.associations.add(association);
        return true;
    }

    private List<Association> getExistingAssociatedPoints(IEntity iEntity, IEntity iEntity2) {
        ArrayList<Association> arrayList = new ArrayList<Association>();
        for (Association association : this.associations) {
            if (!association.sameCouple(iEntity, iEntity2)) continue;
            arrayList.add(association);
        }
        return arrayList;
    }

    class Association {
        private IEntity entity1;
        private IEntity entity2;
        private IEntity associed;
        private IEntity point;
        private Link existingLink;
        private Link entity1ToPoint;
        private Link pointToEntity2;
        private Link pointToAssocied;
        private Association other;

        public Association(int n, IEntity iEntity, IEntity iEntity2, IEntity iEntity3) {
            this.entity1 = iEntity;
            this.entity2 = iEntity2;
            this.associed = iEntity3;
            this.point = AbstractClassOrObjectDiagram.this.getOrCreateLeaf(UniqueSequence.getCode("apoint"), LeafType.POINT_FOR_ASSOCIATION, null);
        }

        public Association createSecondAssociation(int n, IEntity iEntity, Display display) {
            Association association = new Association(n, this.entity1, this.entity2, iEntity);
            association.existingLink = this.existingLink;
            association.other = this;
            if (this.existingLink.getLength() == 1) {
                this.entity1ToPoint.setLength(2);
                this.pointToEntity2.setLength(2);
                this.pointToAssocied.setLength(1);
            }
            return association;
        }

        void createNew(int n, LinkType linkType, Display display) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            IEntity iEntity = this.existingLink.isInverted() ? this.existingLink.getEntity2() : this.existingLink.getEntity1();
            IEntity iEntity2 = this.existingLink.isInverted() ? this.existingLink.getEntity1() : this.existingLink.getEntity2();
            this.entity1ToPoint = new Link(iEntity, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), this.existingLink.getLength(), this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.entity1ToPoint.setLinkArrow(this.existingLink.getLinkArrow());
            this.pointToEntity2 = new Link(this.point, iEntity2, this.existingLink.getType().getPart1(), Display.NULL, this.existingLink.getLength(), null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            int n2 = 1;
            if (this.existingLink.getLength() == 1 && this.entity1 != this.entity2) {
                n2 = 2;
            }
            if (this.existingLink.getLength() == 2 && this.entity1 == this.entity2) {
                n2 = 2;
            }
            if (n2 == 1) {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.NORMAL);
            } else {
                this.entity1ToPoint.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_PRINTED_FULL);
                this.pointToEntity2.addNoteFrom(this.existingLink, NoteLinkStrategy.HALF_NOT_PRINTED);
            }
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            this.pointToAssocied = n == 1 ? new Link(this.point, this.associed, linkType, display, n2) : new Link(this.associed, this.point, linkType, display, n2);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
        }

        void createInSecond(LinkType linkType, Display display) {
            this.existingLink = AbstractClassOrObjectDiagram.this.foundLink(this.entity1, this.entity2);
            if (this.existingLink == null) {
                this.existingLink = new Link(this.entity1, this.entity2, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 2);
            } else {
                AbstractClassOrObjectDiagram.this.removeLink(this.existingLink);
            }
            this.entity1ToPoint = new Link(this.entity1, this.point, this.existingLink.getType().getPart2(), this.existingLink.getLabel(), 2, this.existingLink.getQualifier1(), null, this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            this.pointToEntity2 = new Link(this.point, this.entity2, this.existingLink.getType().getPart1(), Display.NULL, 2, null, this.existingLink.getQualifier2(), this.existingLink.getLabeldistance(), this.existingLink.getLabelangle());
            AbstractClassOrObjectDiagram.this.addLink(this.entity1ToPoint);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToEntity2);
            if (this.other.pointToAssocied.getEntity1().getLeafType() == LeafType.POINT_FOR_ASSOCIATION) {
                AbstractClassOrObjectDiagram.this.removeLink(this.other.pointToAssocied);
                this.other.pointToAssocied = this.other.pointToAssocied.getInv();
                AbstractClassOrObjectDiagram.this.addLink(this.other.pointToAssocied);
            }
            this.pointToAssocied = new Link(this.point, this.associed, linkType, display, 1);
            AbstractClassOrObjectDiagram.this.addLink(this.pointToAssocied);
            Link link = new Link(this.other.point, this.point, new LinkType(LinkDecor.NONE, LinkDecor.NONE), Display.NULL, 1);
            link.setInvis(true);
            AbstractClassOrObjectDiagram.this.addLink(link);
        }

        boolean sameCouple(IEntity iEntity, IEntity iEntity2) {
            if (this.entity1 == iEntity && this.entity2 == iEntity2) {
                return true;
            }
            return this.entity1 == iEntity2 && this.entity2 == iEntity;
        }
    }
}

