/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MetadataTag {
    private final Object source;
    private final String tag;

    public MetadataTag(File file, String string) {
        this.source = file;
        this.tag = string;
    }

    public MetadataTag(InputStream inputStream, String string) {
        this.source = inputStream;
        this.tag = string;
    }

    public String getData() throws IOException {
        ImageInputStream imageInputStream = ImageIO.createImageInputStream(this.source);
        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
        if (iterator.hasNext()) {
            ImageReader imageReader = iterator.next();
            imageReader.setInput(imageInputStream, true);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            String[] stringArray = iIOMetadata.getMetadataFormatNames();
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string = this.displayMetadata(iIOMetadata.getAsTree(stringArray[i]));
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    private String displayMetadata(Node node) {
        return this.displayMetadata(node, 0);
    }

    private String displayMetadata(Node node, int n) {
        Object object;
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem("keyword")) != null && this.tag.equals(node2.getNodeValue()) && (object = namedNodeMap.getNamedItem("value")) != null) {
            return object.getNodeValue();
        }
        for (node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            object = this.displayMetadata(node2, n + 1);
            if (object == null) continue;
            return object;
        }
        return null;
    }
}

