/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.posimo;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import znaishaded.net.sourceforge.plantuml.EnsureVisible;
import znaishaded.net.sourceforge.plantuml.asciiart.BasicCharArea;
import znaishaded.net.sourceforge.plantuml.eps.EpsGraphics;
import znaishaded.net.sourceforge.plantuml.geom.LineSegmentDouble;
import znaishaded.net.sourceforge.plantuml.posimo.BezierUtils;
import znaishaded.net.sourceforge.plantuml.posimo.Moveable;
import znaishaded.net.sourceforge.plantuml.posimo.Positionable;
import znaishaded.net.sourceforge.plantuml.posimo.PositionableUtils;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ClusterPosition;
import znaishaded.net.sourceforge.plantuml.svek.MinFinder;
import znaishaded.net.sourceforge.plantuml.svek.PointAndAngle;
import znaishaded.net.sourceforge.plantuml.svek.PointDirected;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPath;
import znaishaded.net.sourceforge.plantuml.ugraphic.USegmentType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DotPath
implements UShape,
Moveable {
    private final List<CubicCurve2D.Double> beziers = new ArrayList<CubicCurve2D.Double>();
    private String comment;

    public DotPath() {
        this(new ArrayList<CubicCurve2D.Double>());
    }

    public DotPath(DotPath dotPath) {
        this(new ArrayList<CubicCurve2D.Double>());
        for (CubicCurve2D.Double double_ : dotPath.beziers) {
            this.beziers.add(new CubicCurve2D.Double(double_.x1, double_.y1, double_.ctrlx1, double_.ctrly1, double_.ctrlx2, double_.ctrly2, double_.x2, double_.y2));
        }
    }

    private DotPath(List<CubicCurve2D.Double> list) {
        this.beziers.addAll(list);
    }

    public DotPath addCurve(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        arrayList.add(new CubicCurve2D.Double(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY(), point2D4.getX(), point2D4.getY()));
        return new DotPath(arrayList);
    }

    public DotPath addCurve(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        CubicCurve2D.Double double_ = this.beziers.get(this.beziers.size() - 1);
        Point2D point2D4 = double_.getP2();
        return this.addCurve(point2D4, point2D, point2D2, point2D3);
    }

    private Point2D mirror(Point2D point2D, Point2D point2D2) {
        double d = 2.0 * point2D.getX() - point2D2.getX();
        double d2 = 2.0 * point2D.getY() - point2D2.getY();
        return new Point2D.Double(d, d2);
    }

    public DotPath(String string, double d) {
        if (!DotPath.isPathConsistent(string)) {
            throw new IllegalArgumentException();
        }
        int n = string.indexOf("C");
        if (n == -1) {
            throw new IllegalArgumentException();
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string.substring(1, n), ",");
        double d2 = Double.parseDouble(stringTokenizer.nextToken());
        double d3 = Double.parseDouble(stringTokenizer.nextToken()) + d;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string.substring(n + 1), " ");
        ArrayList<TriPoints> arrayList = new ArrayList<TriPoints>();
        while (stringTokenizer2.hasMoreTokens()) {
            String string2 = stringTokenizer2.nextToken();
            String string3 = stringTokenizer2.nextToken();
            String string4 = stringTokenizer2.nextToken();
            arrayList.add(new TriPoints(string2, string3, string4, d));
        }
        double d4 = d2;
        double d5 = d3;
        for (TriPoints triPoints : arrayList) {
            CubicCurve2D.Double double_ = new CubicCurve2D.Double(d4, d5, triPoints.x1, triPoints.y1, triPoints.x2, triPoints.y2, triPoints.x, triPoints.y);
            this.beziers.add(double_);
            d4 = triPoints.x;
            d5 = triPoints.y;
        }
    }

    public static boolean isPathConsistent(String string) {
        return string.startsWith("M");
    }

    public Point2D getStartPoint() {
        return this.beziers.get(0).getP1();
    }

    public PointAndAngle getMiddle() {
        Point2D point2D = null;
        double d = 0.0;
        for (CubicCurve2D.Double double_ : this.beziers) {
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
            double_.subdivide(double_2, double_3);
            Point2D point2D2 = double_2.getP1();
            Point2D point2D3 = double_2.getP2();
            Point2D point2D4 = double_3.getP1();
            Point2D point2D5 = double_3.getP2();
            if (point2D == null || this.getCost(point2D2) < this.getCost(point2D)) {
                point2D = point2D2;
                d = BezierUtils.getStartingAngle(double_2);
            }
            if (this.getCost(point2D3) < this.getCost(point2D)) {
                point2D = point2D3;
                d = BezierUtils.getEndingAngle(double_2);
            }
            if (this.getCost(point2D4) < this.getCost(point2D)) {
                point2D = point2D4;
                d = BezierUtils.getStartingAngle(double_3);
            }
            if (!(this.getCost(point2D5) < this.getCost(point2D))) continue;
            point2D = point2D5;
            d = BezierUtils.getEndingAngle(double_3);
        }
        return new PointAndAngle(point2D, d);
    }

    private double getCost(Point2D point2D) {
        Point2D point2D2 = this.getStartPoint();
        Point2D point2D3 = this.getEndPoint();
        return point2D.distanceSq(point2D2) + point2D.distanceSq(point2D3);
    }

    public void forceStartPoint(double d, double d2) {
        this.beziers.get((int)0).x1 = d;
        this.beziers.get((int)0).y1 = d2;
        this.beziers.get((int)0).ctrlx1 = d;
        this.beziers.get((int)0).ctrly1 = d2;
    }

    public Point2D getEndPoint() {
        return this.beziers.get(this.beziers.size() - 1).getP2();
    }

    public void forceEndPoint(double d, double d2) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 = d;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 = d2;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 = d;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 = d2;
    }

    public void moveEndPoint(double d, double d2) {
        this.beziers.get((int)(this.beziers.size() - 1)).x2 += d;
        this.beziers.get((int)(this.beziers.size() - 1)).y2 += d2;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrlx2 += d;
        this.beziers.get((int)(this.beziers.size() - 1)).ctrly2 += d2;
    }

    public MinFinder getMinFinder() {
        MinFinder minFinder = new MinFinder();
        for (CubicCurve2D.Double double_ : this.beziers) {
            minFinder.manage(double_.x1, double_.y1);
            minFinder.manage(double_.x2, double_.y2);
            minFinder.manage(double_.ctrlx1, double_.ctrly1);
            minFinder.manage(double_.ctrlx2, double_.ctrly2);
        }
        return minFinder;
    }

    public MinMax getMinMax() {
        MinMax minMax = MinMax.getEmpty(false);
        for (CubicCurve2D.Double double_ : this.beziers) {
            minMax = minMax.addPoint(double_.x1, double_.y1);
            minMax = minMax.addPoint(double_.x2, double_.y2);
            minMax = minMax.addPoint(double_.ctrlx1, double_.ctrly1);
            minMax = minMax.addPoint(double_.ctrlx2, double_.ctrly2);
        }
        return minMax;
    }

    public double getMinDist(Point2D point2D) {
        double d = Double.MAX_VALUE;
        for (CubicCurve2D.Double double_ : this.beziers) {
            double d2;
            double d3;
            double d4;
            double d5 = point2D.distance(double_.x1, double_.y1);
            if (d5 < d) {
                d = d5;
            }
            if ((d4 = point2D.distance(double_.x2, double_.y2)) < d) {
                d = d4;
            }
            if ((d3 = point2D.distance(double_.ctrlx1, double_.ctrly1)) < d) {
                d = d3;
            }
            if (!((d2 = point2D.distance(double_.ctrlx2, double_.ctrly2)) < d)) continue;
            d = d2;
        }
        return d;
    }

    public Line2D getEndTangeante() {
        CubicCurve2D.Double double_ = this.beziers.get(this.beziers.size() - 1);
        double d = double_.x2 - double_.ctrlx2;
        double d2 = double_.y2 - double_.ctrly2;
        if (d == 0.0 && d2 == 0.0) {
            d = double_.x2 - double_.x1;
            d2 = double_.y2 - double_.y1;
        }
        return new Line2D.Double(double_.x2, double_.y2, double_.x2 + d, double_.y2 + d2);
    }

    public double getEndAngle() {
        Line2D line2D = this.getEndTangeante();
        double d = Math.atan2(line2D.getY2() - line2D.getY1(), line2D.getX2() - line2D.getX1());
        return d;
    }

    public double getStartAngle() {
        Line2D line2D = this.getStartTangeante();
        double d = Math.atan2(line2D.getY2() - line2D.getY1(), line2D.getX2() - line2D.getX1());
        return d;
    }

    public Line2D getStartTangeante() {
        CubicCurve2D.Double double_ = this.beziers.get(0);
        double d = double_.ctrlx1 - double_.x1;
        double d2 = double_.ctrly1 - double_.y1;
        if (d == 0.0 && d2 == 0.0) {
            d = double_.x2 - double_.x1;
            d2 = double_.y2 - double_.y1;
        }
        return new Line2D.Double(double_.x1, double_.y1, double_.x1 + d, double_.y1 + d2);
    }

    public DotPath addBefore(CubicCurve2D.Double double_) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        arrayList.add(0, double_);
        return new DotPath(arrayList);
    }

    private DotPath addBefore(DotPath dotPath) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        arrayList.addAll(0, dotPath.beziers);
        return new DotPath(arrayList);
    }

    public DotPath addAfter(CubicCurve2D.Double double_) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        arrayList.add(double_);
        return new DotPath(arrayList);
    }

    public DotPath addAfter(DotPath dotPath) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        arrayList.addAll(dotPath.beziers);
        return new DotPath(arrayList);
    }

    public Map<Point2D, Double> somePoints() {
        HashMap<Point2D, Double> hashMap = new HashMap<Point2D, Double>();
        for (CubicCurve2D.Double double_ : this.beziers) {
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
            double_.subdivide(double_2, double_3);
            hashMap.put(double_2.getP1(), BezierUtils.getStartingAngle(double_2));
            hashMap.put(double_2.getP2(), BezierUtils.getEndingAngle(double_2));
            hashMap.put(double_3.getP1(), BezierUtils.getStartingAngle(double_3));
            hashMap.put(double_3.getP2(), BezierUtils.getEndingAngle(double_3));
        }
        return hashMap;
    }

    private PointDirected getIntersection(ClusterPosition clusterPosition) {
        for (CubicCurve2D.Double double_ : this.beziers) {
            PointDirected pointDirected = clusterPosition.getIntersection(double_);
            if (pointDirected == null) continue;
            return pointDirected;
        }
        return null;
    }

    public void draw(Graphics2D graphics2D, double d, double d2) {
        GeneralPath generalPath = new GeneralPath();
        for (CubicCurve2D.Double double_ : this.beziers) {
            double_ = new CubicCurve2D.Double(d + double_.x1, d2 + double_.y1, d + double_.ctrlx1, d2 + double_.ctrly1, d + double_.ctrlx2, d2 + double_.ctrly2, d + double_.x2, d2 + double_.y2);
            generalPath.append(double_, true);
        }
        graphics2D.draw(generalPath);
    }

    public void manageEnsureVisible(double d, double d2, EnsureVisible ensureVisible) {
        for (CubicCurve2D.Double double_ : this.beziers) {
            ensureVisible.ensureVisible(d + double_.x1, d2 + double_.y1);
            ensureVisible.ensureVisible(d + double_.x2, d2 + double_.y2);
        }
    }

    public void drawOk(EpsGraphics epsGraphics, double d, double d2) {
        for (CubicCurve2D.Double double_ : this.beziers) {
            double_ = new CubicCurve2D.Double(d + double_.x1, d2 + double_.y1, d + double_.ctrlx1, d2 + double_.ctrly1, d + double_.ctrlx2, d2 + double_.ctrly2, d + double_.x2, d2 + double_.y2);
            epsGraphics.epsLine(double_.x1, double_.y1, double_.x2, double_.y2);
        }
    }

    public void draw(EpsGraphics epsGraphics, double d, double d2) {
        epsGraphics.newpathDot();
        boolean bl = true;
        for (CubicCurve2D.Double double_ : this.beziers) {
            double_ = new CubicCurve2D.Double(d + double_.x1, d2 + double_.y1, d + double_.ctrlx1, d2 + double_.ctrly1, d + double_.ctrlx2, d2 + double_.ctrly2, d + double_.x2, d2 + double_.y2);
            if (bl) {
                epsGraphics.movetoNoMacro(double_.x1, double_.y1);
                bl = false;
            }
            epsGraphics.curvetoNoMacro(double_.ctrlx1, double_.ctrly1, double_.ctrlx2, double_.ctrly2, double_.x2, double_.y2);
        }
        epsGraphics.closepathDot();
    }

    public UPath toUPath() {
        UPath uPath = new UPath(this.comment);
        boolean bl = true;
        for (CubicCurve2D.Double double_ : this.beziers) {
            if (bl) {
                uPath.add(new double[]{double_.x1, double_.y1}, USegmentType.SEG_MOVETO);
                bl = false;
            }
            uPath.add(new double[]{double_.ctrlx1, double_.ctrly1, double_.ctrlx2, double_.ctrly2, double_.x2, double_.y2}, USegmentType.SEG_CUBICTO);
        }
        return uPath;
    }

    private Point2D getFrontierIntersection(Shape shape, Rectangle2D ... rectangle2DArray) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        for (int i = 0; i < 8; ++i) {
            for (CubicCurve2D.Double double_ : arrayList) {
                if (DotPath.contains(double_, rectangle2DArray)) continue;
                CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
                double_2.setCurve(double_);
                if (!BezierUtils.isCutting(double_2, shape)) continue;
                while (BezierUtils.dist(double_2) > 1.0) {
                    BezierUtils.shorten(double_2, shape);
                }
                Point2D.Double double_3 = new Point2D.Double((double_2.x1 + double_2.x2) / 2.0, (double_2.y1 + double_2.y2) / 2.0);
                if (DotPath.contains(double_3, rectangle2DArray)) continue;
                return double_3;
            }
            this.cutAllCubic(arrayList);
        }
        throw new IllegalArgumentException("shape=" + shape);
    }

    private void cutAllCubic(List<CubicCurve2D.Double> list) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(list);
        list.clear();
        for (CubicCurve2D.Double double_ : arrayList) {
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            CubicCurve2D.Double double_3 = new CubicCurve2D.Double();
            double_.subdivide(double_2, double_3);
            list.add(double_2);
            list.add(double_3);
        }
    }

    private static boolean contains(Point2D.Double double_, Rectangle2D ... rectangle2DArray) {
        for (Rectangle2D rectangle2D : rectangle2DArray) {
            if (!rectangle2D.contains(double_)) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(CubicCurve2D.Double double_, Rectangle2D ... rectangle2DArray) {
        for (Rectangle2D rectangle2D : rectangle2DArray) {
            if (!rectangle2D.contains(double_.getP1()) || !rectangle2D.contains(double_.getP2())) continue;
            return true;
        }
        return false;
    }

    private DotPath manageRect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        while (true) {
            if (!BezierUtils.isCutting((CubicCurve2D.Double)arrayList.get(0), rectangle2D)) {
                throw new IllegalStateException();
            }
            if (BezierUtils.dist((CubicCurve2D.Double)arrayList.get(0)) <= 1.0) break;
            CubicCurve2D.Double double_ = new CubicCurve2D.Double();
            CubicCurve2D.Double double_2 = new CubicCurve2D.Double();
            ((CubicCurve2D.Double)arrayList.get(0)).subdivide(double_, double_2);
            arrayList.set(0, double_);
            arrayList.add(1, double_2);
            if (!BezierUtils.isCutting((CubicCurve2D.Double)arrayList.get(1), rectangle2D)) continue;
            arrayList.remove(0);
        }
        return new DotPath(arrayList);
    }

    private Point2D getFrontierIntersection(Positionable positionable) {
        return this.getFrontierIntersection(PositionableUtils.convert(positionable), new Rectangle2D[0]);
    }

    public void draw(BasicCharArea basicCharArea, double d, double d2) {
        for (CubicCurve2D.Double double_ : this.beziers) {
            if (double_.x1 == double_.x2) {
                basicCharArea.drawVLine('|', (int)(double_.x1 / d), (int)(double_.y1 / d2), (int)(double_.y2 / d2));
                continue;
            }
            if (double_.y1 != double_.y2) continue;
            basicCharArea.drawHLine('-', (int)(double_.y1 / d2), (int)(double_.x1 / d), (int)(double_.x2 / d));
        }
    }

    static String toString(CubicCurve2D.Double double_) {
        return "(" + double_.x1 + "," + double_.y1 + ") " + "(" + double_.ctrlx1 + "," + double_.ctrly1 + ") " + "(" + double_.ctrlx2 + "," + double_.ctrly2 + ") " + "(" + double_.x2 + "," + double_.y2 + ") ";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (CubicCurve2D.Double double_ : this.beziers) {
            stringBuilder.append(DotPath.toString(double_));
            stringBuilder.append(" - ");
        }
        return stringBuilder.toString();
    }

    public static CubicCurve2D.Double reverse(CubicCurve2D cubicCurve2D) {
        return new CubicCurve2D.Double(cubicCurve2D.getX2(), cubicCurve2D.getY2(), cubicCurve2D.getCtrlX2(), cubicCurve2D.getCtrlY2(), cubicCurve2D.getCtrlX1(), cubicCurve2D.getCtrlY1(), cubicCurve2D.getX1(), cubicCurve2D.getY1());
    }

    public DotPath reverse() {
        ArrayList<CubicCurve2D.Double> arrayList = new ArrayList<CubicCurve2D.Double>(this.beziers);
        Collections.reverse(arrayList);
        ArrayList<CubicCurve2D.Double> arrayList2 = new ArrayList<CubicCurve2D.Double>();
        for (CubicCurve2D.Double double_ : arrayList) {
            arrayList2.add(DotPath.reverse(double_));
        }
        return new DotPath(arrayList2);
    }

    @Override
    public void moveSvek(double d, double d2) {
        for (int i = 0; i < this.beziers.size(); ++i) {
            CubicCurve2D.Double double_ = this.beziers.get(i);
            this.beziers.set(i, new CubicCurve2D.Double(double_.x1 + d, double_.y1 + d2, double_.ctrlx1 + d, double_.ctrly1 + d2, double_.ctrlx2 + d, double_.ctrly2 + d2, double_.x2 + d, double_.y2 + d2));
        }
    }

    public final List<CubicCurve2D.Double> getBeziers() {
        return Collections.unmodifiableList(this.beziers);
    }

    /*
     * WARNING - void declaration
     */
    public DotPath simulateCompound(Cluster cluster, Cluster cluster2) {
        CubicCurve2D.Double double_;
        CubicCurve2D.Double double_2;
        int n;
        Object object;
        Object object2;
        if (cluster == null && cluster2 == null) {
            return this;
        }
        Object object3 = this;
        if (cluster2 != null && ((ClusterPosition)(object2 = cluster2.getClusterPosition())).contains(this.getStartPoint())) {
            object = new DotPath();
            int n2 = 0;
            while (n2 + 1 < this.beziers.size() && ((ClusterPosition)object2).contains(this.beziers.get(n2).getP2())) {
                if (!((ClusterPosition)object2).contains(this.beziers.get(n2).getP1())) {
                    throw new IllegalStateException();
                }
                ++n2;
            }
            if (!((ClusterPosition)object2).contains(this.beziers.get(n2).getP2())) {
                assert (((ClusterPosition)object2).contains(this.beziers.get(n2).getP1()));
                assert (!((ClusterPosition)object2).contains(this.beziers.get(n2).getP2()));
                CubicCurve2D cubicCurve2D = this.beziers.get(n2);
                for (n = 0; n < 8; ++n) {
                    void var7_9;
                    double_2 = new CubicCurve2D.Double();
                    double_ = new CubicCurve2D.Double();
                    var7_9.subdivide(double_2, double_);
                    assert (double_2.getP2().equals(double_.getP1()));
                    if (((ClusterPosition)object2).contains(double_2.getP2())) {
                        CubicCurve2D.Double double_3 = double_;
                        continue;
                    }
                    ((DotPath)object).beziers.add(0, double_);
                    CubicCurve2D.Double double_4 = double_2;
                }
                for (n = n2 + 1; n < this.beziers.size(); ++n) {
                    ((DotPath)object).beziers.add(this.beziers.get(n));
                }
                object3 = object;
            }
        }
        if (cluster != null) {
            object2 = new DotPath();
            object = cluster.getClusterPosition();
            if (((ClusterPosition)object).contains(this.getEndPoint())) {
                for (CubicCurve2D.Double double_5 : ((DotPath)object3).beziers) {
                    if (!((ClusterPosition)object).contains(double_5.getP2())) {
                        ((DotPath)object2).beziers.add(double_5);
                        continue;
                    }
                    if (((ClusterPosition)object).contains(double_5.getP1())) {
                        return object3;
                    }
                    assert (!((ClusterPosition)object).contains(double_5.getP1()));
                    assert (((ClusterPosition)object).contains(double_5.getP2()));
                    for (n = 0; n < 8; ++n) {
                        void var7_15;
                        double_2 = new CubicCurve2D.Double();
                        double_ = new CubicCurve2D.Double();
                        var7_15.subdivide(double_2, double_);
                        assert (double_2.getP2().equals(double_.getP1()));
                        if (((ClusterPosition)object).contains(double_2.getP2())) {
                            CubicCurve2D.Double double_6 = double_2;
                            continue;
                        }
                        ((DotPath)object2).beziers.add(double_2);
                        CubicCurve2D.Double double_7 = double_;
                    }
                    return object2;
                }
            }
        }
        return object3;
    }

    private double length(CubicCurve2D cubicCurve2D) {
        return cubicCurve2D.getP1().distance(cubicCurve2D.getP2());
    }

    public boolean isLine() {
        for (CubicCurve2D.Double double_ : this.beziers) {
            if (!(double_.getFlatnessSq() > 0.001)) continue;
            return false;
        }
        return true;
    }

    public List<LineSegmentDouble> getLineSegments() {
        ArrayList<LineSegmentDouble> arrayList = new ArrayList<LineSegmentDouble>();
        for (CubicCurve2D.Double double_ : this.beziers) {
            if (!(double_.getFlatnessSq() <= 0.001)) continue;
            arrayList.add(new LineSegmentDouble(double_));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public void setComment(String string) {
        this.comment = string;
    }

    static class TriPoints {
        private final double x1;
        private final double y1;
        private final double x2;
        private final double y2;
        private final double x;
        private final double y;

        public TriPoints(String string, String string2, String string3, double d) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            this.x1 = Double.parseDouble(stringTokenizer.nextToken());
            this.y1 = Double.parseDouble(stringTokenizer.nextToken()) + d;
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            this.x2 = Double.parseDouble(stringTokenizer2.nextToken());
            this.y2 = Double.parseDouble(stringTokenizer2.nextToken()) + d;
            StringTokenizer stringTokenizer3 = new StringTokenizer(string3, ",");
            this.x = Double.parseDouble(stringTokenizer3.nextToken());
            this.y = Double.parseDouble(stringTokenizer3.nextToken()) + d;
        }
    }
}

