/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.preproc;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.preproc.Define;
import znaishaded.net.sourceforge.plantuml.preproc.EvalBoolean;
import znaishaded.net.sourceforge.plantuml.preproc.Truth;
import znaishaded.net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Defines
implements Truth {
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private final Map<String, Define> values = new LinkedHashMap<String, Define>();
    private final Map<String, Define> savedState = new LinkedHashMap<String, Define>();
    private static final String DATE = "(?i)%date(\\[(.+?)\\])?%";
    private static final Pattern datePattern = Pattern.compile("(?i)%date(\\[(.+?)\\])?%");

    @Deprecated
    public Defines() {
        this.environment.put("PLANTUML_VERSION", "" + Version.versionString());
    }

    public String toString() {
        return this.values.keySet().toString();
    }

    public static Defines createEmpty() {
        return new Defines();
    }

    public void importFrom(Defines defines) {
        this.environment.putAll(defines.environment);
        this.values.putAll(defines.values);
    }

    public Defines cloneMe() {
        Defines defines = new Defines();
        defines.importFrom(this);
        return defines;
    }

    public static Defines createWithFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        Defines defines = Defines.createEmpty();
        defines.environment.put("filedate", new Date(file.lastModified()).toString());
        defines.environment.put("filename", file.getName());
        defines.environment.put("filenameNoExtension", Defines.nameNoExtension(file));
        defines.environment.put("dirpath", file.getAbsoluteFile().getParentFile().getAbsolutePath().replace('\\', '/'));
        return defines;
    }

    private static String nameNoExtension(File file) {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    public void define(String string, List<String> list, boolean bl) {
        this.values.put(string, new Define(string, list, bl));
    }

    public boolean isDefine(String string) {
        try {
            EvalBoolean evalBoolean = new EvalBoolean(string, this);
            return evalBoolean.eval();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.info("Error in " + string);
            return false;
        }
    }

    @Override
    public boolean isTrue(String string) {
        for (String string2 : this.values.keySet()) {
            if (!string2.equals(string) && !string2.startsWith(string + "(")) continue;
            return true;
        }
        return false;
    }

    public void undefine(String string) {
        this.values.remove(string);
    }

    public List<String> applyDefines(String string) {
        string = this.manageDate(string);
        string = this.manageEnvironment(string);
        for (Map.Entry<String, Define> entry : this.values.entrySet()) {
            Define define = entry.getValue();
            string = define.apply(string);
        }
        return Arrays.asList(string.split("\n"));
    }

    private String manageEnvironment(String string) {
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            String string2 = Pattern.quote("%" + entry.getKey() + "%");
            string = string.replaceAll(string2, entry.getValue());
        }
        return string;
    }

    private String manageDate(String string) {
        Matcher matcher = datePattern.matcher(string);
        if (matcher.find()) {
            String string2;
            String string3 = matcher.group(2);
            if (string3 == null) {
                string2 = new Date().toString();
            } else {
                try {
                    string2 = new SimpleDateFormat(string3).format(new Date());
                }
                catch (Exception exception) {
                    string2 = "(BAD DATE PATTERN:" + string3 + ")";
                }
            }
            string = string.replaceAll(DATE, string2);
        }
        return string;
    }

    public void saveState() {
        if (this.savedState.size() > 0) {
            throw new IllegalStateException();
        }
        this.savedState.putAll(this.values);
    }

    public void restoreState() {
        this.values.clear();
        this.values.putAll(this.savedState);
    }
}

