/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.project.Duration;
import znaishaded.net.sourceforge.plantuml.project.Instant;
import znaishaded.net.sourceforge.plantuml.project.Item;
import znaishaded.net.sourceforge.plantuml.project.Load;
import znaishaded.net.sourceforge.plantuml.project.NumericNumber;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParentItem
implements Item {
    private final String code;
    private final Item parent;
    private final List<Item> children = new ArrayList<Item>();

    public ParentItem(String string, Item item2) {
        this.code = string;
        this.parent = item2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.code + " {");
        Iterator<Item> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            Item item2 = iterator.next();
            stringBuilder.append(item2.getCode());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    @Override
    public Instant getBegin() {
        Instant instant = null;
        for (Item item2 : this.children) {
            if (instant != null && instant.compareTo(item2.getBegin()) <= 0) continue;
            instant = item2.getBegin();
        }
        return instant;
    }

    @Override
    public Instant getCompleted() {
        Instant instant = null;
        for (Item item2 : this.children) {
            if (instant != null && instant.compareTo(item2.getCompleted()) >= 0) continue;
            instant = item2.getCompleted();
        }
        return instant;
    }

    @Override
    public Duration getDuration() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Load getLoad() {
        throw new UnsupportedOperationException();
    }

    @Override
    public NumericNumber getWork() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public Item getParent() {
        return this.parent;
    }

    @Override
    public List<Item> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public String getCode() {
        return this.code;
    }

    public void addChild(Item item2) {
        this.children.add(item2);
    }

    @Override
    public boolean isValid() {
        if (this.children.size() == 0) {
            return false;
        }
        for (Item item2 : this.children) {
            if (item2.isValid()) continue;
            return false;
        }
        return true;
    }
}

