/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project2;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.SpriteContainerEmpty;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.project2.Day;
import znaishaded.net.sourceforge.plantuml.project2.TimeLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class TimeHeaderDay
extends AbstractTextBlock
implements TextBlock {
    private final Day start;
    private final Day end;
    private final TimeLine timeline;
    private final double dayWidth;
    private final UFont font = UFont.serif(9);
    private final FontConfiguration fontConfig = FontConfiguration.blackBlueTrue(this.font);

    public TimeHeaderDay(Day day, Day day2, TimeLine timeLine, double d) {
        this.start = day;
        this.end = day2;
        this.timeline = timeLine;
        this.dayWidth = d;
    }

    public void drawU(UGraphic uGraphic) {
        int n = 0;
        Day day = this.start;
        while (day.compareTo(this.end) <= 0) {
            String string = "" + day.getNumDay();
            TextBlock textBlock = Display.create(string).create(this.fontConfig, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
            Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
            double d = this.dayWidth - dimension2D.getWidth();
            double d2 = this.getHeight() - dimension2D.getHeight();
            uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
            uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.WHITE));
            uGraphic.apply(new UTranslate((double)n * this.dayWidth, 0.0)).draw(new URectangle(this.dayWidth, this.getHeight()));
            textBlock.drawU(uGraphic.apply(new UTranslate((double)n * this.dayWidth + d / 2.0, d2 / 2.0)));
            ++n;
            day = (Day)this.timeline.next(day);
        }
    }

    private double getHeight() {
        return 20.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        int n = 0;
        Day day = this.start;
        while (day.compareTo(this.end) <= 0) {
            ++n;
            day = (Day)this.timeline.next(day);
        }
        return new Dimension2DDouble((double)n * this.dayWidth, this.getHeight());
    }
}

