/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import znaishaded.net.sourceforge.plantuml.project3.Complement;
import znaishaded.net.sourceforge.plantuml.project3.Instant;
import znaishaded.net.sourceforge.plantuml.project3.Task;
import znaishaded.net.sourceforge.plantuml.project3.TaskAttribute;

public class TaskInstant
implements Complement {
    private final Task task;
    private final TaskAttribute attribute;
    private final int delta;

    public TaskInstant(Task task, TaskAttribute taskAttribute) {
        this(task, taskAttribute, 0);
    }

    private TaskInstant(Task task, TaskAttribute taskAttribute, int n) {
        this.task = task;
        this.attribute = taskAttribute;
        this.delta = n;
        if (taskAttribute != TaskAttribute.START && taskAttribute != TaskAttribute.END) {
            throw new IllegalArgumentException();
        }
    }

    public TaskInstant withDelta(int n) {
        return new TaskInstant(this.task, this.attribute, n);
    }

    private Instant manageDelta(Instant instant) {
        int n;
        if (this.delta > 0) {
            for (n = 0; n < this.delta; ++n) {
                instant = instant.increment();
            }
        }
        if (this.delta < 0) {
            for (n = 0; n < -this.delta; ++n) {
                instant = instant.decrement();
            }
        }
        return instant;
    }

    public Instant getInstantPrecise() {
        if (this.attribute == TaskAttribute.START) {
            return this.manageDelta(this.task.getStart());
        }
        if (this.attribute == TaskAttribute.END) {
            return this.manageDelta(this.task.getEnd().increment());
        }
        throw new IllegalStateException();
    }

    public Instant getInstantTheorical() {
        if (this.attribute == TaskAttribute.START) {
            return this.manageDelta(this.task.getStart());
        }
        if (this.attribute == TaskAttribute.END) {
            return this.manageDelta(this.task.getEnd());
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return this.attribute.toString() + " of " + this.task;
    }

    public final Task getTask() {
        return this.task;
    }

    public final TaskAttribute getAttribute() {
        return this.attribute;
    }
}

