/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import znaishaded.net.sourceforge.plantuml.project3.DayAsDate;
import znaishaded.net.sourceforge.plantuml.project3.DayOfWeek;
import znaishaded.net.sourceforge.plantuml.project3.GCalendar;
import znaishaded.net.sourceforge.plantuml.project3.Instant;
import znaishaded.net.sourceforge.plantuml.project3.InstantDay;
import znaishaded.net.sourceforge.plantuml.project3.TimeScale;

public class TimeScaleWithoutWeekEnd
implements TimeScale {
    private final double scale = 16.0;
    private final GCalendar calendar;

    public TimeScaleWithoutWeekEnd(GCalendar gCalendar) {
        if (gCalendar == null) {
            throw new IllegalArgumentException();
        }
        this.calendar = gCalendar;
    }

    public double getStartingPosition(Instant instant) {
        double d = 0.0;
        InstantDay instantDay = (InstantDay)instant;
        while (instantDay.getNumDay() > 0) {
            instantDay = instantDay.decrement();
            d += this.getWidth(instantDay);
        }
        return d;
    }

    public double getWidth(Instant instant) {
        DayAsDate dayAsDate = this.calendar.toDayAsDate((InstantDay)instant);
        DayOfWeek dayOfWeek = dayAsDate.getDayOfWeek();
        if (dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            return 1.0;
        }
        return 16.0;
    }
}

