/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.command;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandAutonumberIncrement
extends SingleLineCommand2<SequenceDiagram> {
    public CommandAutonumberIncrement() {
        super(CommandAutonumberIncrement.getConcat());
    }

    private static RegexConcat getConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("autonumber"), new RegexLeaf("[%s]+"), new RegexLeaf("inc"), new RegexLeaf("POS", "(?:[%s]+([A-Za-z]))?"), new RegexLeaf("[%s]*"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
        String string = regexResult.get("POS", 0);
        if (string == null) {
            sequenceDiagram.getAutoNumber().incrementIntermediate();
        } else {
            int n = StringUtils.goLowerCase(string.charAt(0)) - 97;
            sequenceDiagram.getAutoNumber().incrementIntermediate(n);
        }
        return CommandExecutionResult.ok();
    }
}

