/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Segment {
    private final double pos1;
    private final double pos2;

    public Segment(double d, double d2) {
        this.pos1 = d;
        this.pos2 = d2;
        if (d2 < d) {
            throw new IllegalArgumentException();
        }
    }

    public boolean equals(Object object) {
        Segment segment2 = (Segment)object;
        return this.pos1 == segment2.pos1 && this.pos2 == segment2.pos2;
    }

    public int hashCode() {
        return new Double(this.pos1).hashCode() + new Double(this.pos2).hashCode();
    }

    public final boolean contains(double d) {
        return d >= this.pos1 && d <= this.pos2;
    }

    public final boolean contains(Segment segment2) {
        return this.contains(segment2.pos1) && this.contains(segment2.pos2);
    }

    public String toString() {
        return "" + this.pos1 + " - " + this.pos2;
    }

    public final double getLength() {
        return this.pos2 - this.pos1;
    }

    public final double getPos1() {
        return this.pos1;
    }

    public final double getPos2() {
        return this.pos2;
    }

    public Segment merge(Segment segment2) {
        return new Segment(Math.min(this.pos1, segment2.pos1), Math.max(this.pos2, segment2.pos2));
    }

    public Collection<Segment> cutSegmentIfNeed(Collection<Segment> collection) {
        ArrayList<Segment> arrayList = new ArrayList<Segment>(collection);
        Collections.sort(arrayList, new SortPos1());
        ArrayList<Segment> arrayList2 = new ArrayList<Segment>();
        double d = this.pos1;
        for (Segment segment2 : arrayList) {
            if (segment2.pos1 <= d) continue;
            if (segment2.pos1 > this.pos2) {
                arrayList2.add(new Segment(d, this.pos2));
                return Collections.unmodifiableCollection(arrayList2);
            }
            if (!this.contains(segment2)) continue;
            arrayList2.add(new Segment(d, segment2.pos1));
            d = segment2.pos2;
        }
        arrayList2.add(new Segment(d, this.pos2));
        return Collections.unmodifiableCollection(arrayList2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SortPos1
    implements Comparator<Segment> {
        SortPos1() {
        }

        @Override
        public int compare(Segment segment2, Segment segment3) {
            return (int)Math.signum(segment2.pos1 - segment3.pos1);
        }
    }
}

