/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.SimpleContext2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SegmentColored {
    private final Segment segment;
    private final SymbolContext colors;
    private final boolean shadowing;
    private final double pos1Initial;

    SegmentColored(double d, double d2, SymbolContext symbolContext, boolean bl) {
        this(new Segment(d, d2), symbolContext, bl, d);
    }

    private SegmentColored(Segment segment2, SymbolContext symbolContext, boolean bl, double d) {
        this.segment = segment2;
        this.colors = symbolContext;
        this.shadowing = bl;
        this.pos1Initial = d;
    }

    public HtmlColor getSpecificBackColor() {
        if (this.colors == null) {
            return null;
        }
        return this.colors.getBackColor();
    }

    public HtmlColor getSpecificLineColor() {
        if (this.colors == null) {
            return null;
        }
        return this.colors.getForeColor();
    }

    public boolean equals(Object object) {
        SegmentColored segmentColored = (SegmentColored)object;
        return this.segment.equals(segmentColored.segment);
    }

    public int hashCode() {
        return this.segment.hashCode();
    }

    public String toString() {
        return this.segment.toString();
    }

    public void drawU(UGraphic uGraphic, Component component, int n) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UTranslate((double)(n - 1) * component.getPreferredWidth(stringBounder) / 2.0, this.segment.getPos1()));
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(component.getPreferredWidth(stringBounder), this.segment.getPos2() - this.segment.getPos1());
        component.drawU(uGraphic, new Area(dimension2DDouble), new SimpleContext2D(false));
    }

    public Collection<SegmentColored> cutSegmentIfNeed(Collection<Segment> collection) {
        return new Coll2(this.segment.cutSegmentIfNeed(collection), this.segment.getPos1());
    }

    public double getPos1Initial() {
        return this.pos1Initial;
    }

    public SegmentColored merge(SegmentColored segmentColored) {
        Segment segment2 = this.segment.merge(segmentColored.segment);
        return new SegmentColored(segment2, this.colors, this.shadowing, segment2.getPos1());
    }

    public final Segment getSegment() {
        return this.segment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Coll2
    extends AbstractCollection<SegmentColored> {
        private final Collection<Segment> col;
        private final double pos1Initial;

        public Coll2(Collection<Segment> collection, double d) {
            this.col = collection;
            this.pos1Initial = d;
        }

        @Override
        public Iterator<SegmentColored> iterator() {
            return new Iterator2(this.col.iterator(), this.pos1Initial);
        }

        @Override
        public int size() {
            return this.col.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Iterator2
    implements Iterator<SegmentColored> {
        private final Iterator<Segment> it;
        private final double pos1Initial;

        public Iterator2(Iterator<Segment> iterator, double d) {
            this.it = iterator;
            this.pos1Initial = d;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SegmentColored next() {
            return new SegmentColored(this.it.next(), SegmentColored.this.colors, SegmentColored.this.shadowing, this.pos1Initial);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

