/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcolored;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiveBoxesDrawer {
    private double y1;
    private SymbolContext color;
    private final Component cross;
    private final Context2D context;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final Component compForWidth;
    private final Collection<Segment> delays;

    public LiveBoxesDrawer(Context2D context2D, Skin skin, ISkinParam iSkinParam, Map<Double, Double> map) {
        this.cross = skin.createComponent(ComponentType.DESTROY, null, iSkinParam, null);
        this.compForWidth = skin.createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, iSkinParam, null);
        this.context = context2D;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.delays = new HashSet<Segment>();
        for (Map.Entry<Double, Double> entry : map.entrySet()) {
            this.delays.add(new Segment(entry.getKey(), entry.getKey() + entry.getValue()));
        }
    }

    public double getWidth(StringBounder stringBounder) {
        return this.compForWidth.getPreferredWidth(stringBounder);
    }

    public void addStart(double d, SymbolContext symbolContext) {
        this.y1 = d;
        this.color = symbolContext;
    }

    public void doDrawing(UGraphic uGraphic, StairsPosition stairsPosition) {
        Segment segment2 = new Segment(this.y1, stairsPosition.getValue());
        Collection<Segment> collection = segment2.cutSegmentIfNeed(this.delays);
        ComponentType componentType = ComponentType.ALIVE_BOX_CLOSE_CLOSE;
        if (collection.size() > 1) {
            componentType = ComponentType.ALIVE_BOX_CLOSE_OPEN;
        }
        Iterator<Segment> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Segment segment3 = iterator.next();
            if (!iterator.hasNext() && componentType != ComponentType.ALIVE_BOX_CLOSE_CLOSE) {
                componentType = ComponentType.ALIVE_BOX_OPEN_CLOSE;
            }
            this.drawInternal(uGraphic, stairsPosition, segment3.getPos1(), segment3.getPos2(), componentType);
            componentType = ComponentType.ALIVE_BOX_OPEN_OPEN;
        }
        this.y1 = Double.MAX_VALUE;
    }

    public void drawDestroyIfNeeded(UGraphic uGraphic, StairsPosition stairsPosition) {
        if (stairsPosition.isDestroy()) {
            Dimension2D dimension2D = this.cross.getPreferredDimension(uGraphic.getStringBounder());
            this.cross.drawU(uGraphic.apply(new UTranslate(-dimension2D.getWidth() / 2.0, stairsPosition.getValue() - dimension2D.getHeight() / 2.0)), null, this.context);
        }
    }

    private void drawInternal(UGraphic uGraphic, StairsPosition stairsPosition, double d, double d2, ComponentType componentType) {
        double d3 = this.getWidth(uGraphic.getStringBounder());
        Area area = new Area(d3, d2 - d);
        SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(this.skinParam, this.color == null ? null : this.color.getBackColor());
        Component component = this.skin.createComponent(componentType, null, skinParamBackcolored, null);
        component.drawU(uGraphic.apply(new UTranslate(-d3 / 2.0, d)), area, this.context);
    }
}

