/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Delay;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantEnglober;
import znaishaded.net.sourceforge.plantuml.sequencediagram.ParticipantType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistory;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LiveBoxes;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.MutingLine;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LivingSpace {
    private final Participant p;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final ComponentType headType;
    private final ComponentType tailType;
    private final boolean useContinueLineBecauseOfDelay;
    private final MutingLine mutingLine;
    private final Rose rose = new Rose();
    private final LiveBoxes liveBoxes;
    private final Real posB;
    private Real posC;
    private Real posD;
    private final EventsHistory eventsHistory;
    private boolean create = false;
    private double createY = 0.0;
    private final ParticipantEnglober englober;

    public int getLevelAt(Tile tile, EventsHistoryMode eventsHistoryMode) {
        return this.eventsHistory.getLevelAt(tile.getEvent(), eventsHistoryMode);
    }

    public void addStepForLivebox(Event event, double d) {
        this.eventsHistory.addStepForLivebox(event, d);
    }

    public String toString() {
        return this.p.getCode() + " B=" + this.posB.getCurrentValue() + "/C=" + LivingSpace.currentValue(this.posC) + "/D=" + LivingSpace.currentValue(this.posD);
    }

    private static String currentValue(Real real) {
        if (real == null) {
            return null;
        }
        return "" + real.getCurrentValue();
    }

    public LivingSpace(Participant participant, ParticipantEnglober participantEnglober, Skin skin, ISkinParam iSkinParam, Real real, List<Event> list) {
        this.eventsHistory = new EventsHistory(participant, list);
        this.p = participant;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.englober = participantEnglober;
        this.posB = real;
        if (participant.getType() == ParticipantType.PARTICIPANT) {
            this.headType = ComponentType.PARTICIPANT_HEAD;
            this.tailType = ComponentType.PARTICIPANT_TAIL;
        } else if (participant.getType() == ParticipantType.ACTOR) {
            this.headType = ComponentType.ACTOR_HEAD;
            this.tailType = ComponentType.ACTOR_TAIL;
        } else if (participant.getType() == ParticipantType.BOUNDARY) {
            this.headType = ComponentType.BOUNDARY_HEAD;
            this.tailType = ComponentType.BOUNDARY_TAIL;
        } else if (participant.getType() == ParticipantType.CONTROL) {
            this.headType = ComponentType.CONTROL_HEAD;
            this.tailType = ComponentType.CONTROL_TAIL;
        } else if (participant.getType() == ParticipantType.ENTITY) {
            this.headType = ComponentType.ENTITY_HEAD;
            this.tailType = ComponentType.ENTITY_TAIL;
        } else if (participant.getType() == ParticipantType.QUEUE) {
            this.headType = ComponentType.QUEUE_HEAD;
            this.tailType = ComponentType.QUEUE_TAIL;
        } else if (participant.getType() == ParticipantType.DATABASE) {
            this.headType = ComponentType.DATABASE_HEAD;
            this.tailType = ComponentType.DATABASE_TAIL;
        } else if (participant.getType() == ParticipantType.COLLECTIONS) {
            this.headType = ComponentType.COLLECTIONS_HEAD;
            this.tailType = ComponentType.COLLECTIONS_TAIL;
        } else {
            throw new IllegalArgumentException();
        }
        this.useContinueLineBecauseOfDelay = this.useContinueLineBecauseOfDelay(list);
        this.mutingLine = new MutingLine(skin, iSkinParam, list);
        this.liveBoxes = new LiveBoxes(this.eventsHistory, skin, iSkinParam, participant);
    }

    private boolean useContinueLineBecauseOfDelay(List<Event> list) {
        String string = this.skinParam.getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(string)) {
            return false;
        }
        for (Event event : list) {
            if (!(event instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public void drawLineAndLiveBoxes(UGraphic uGraphic, double d, Context2D context2D) {
        this.mutingLine.drawLine(uGraphic, context2D, this.createY, d);
        this.liveBoxes.drawBoxes(uGraphic, context2D, this.createY, d);
    }

    public void drawHead(UGraphic uGraphic, Context2D context2D, VerticalAlignment verticalAlignment, HorizontalAlignment horizontalAlignment) {
        if (this.create && verticalAlignment == VerticalAlignment.BOTTOM) {
            return;
        }
        Component component = this.rose.createComponent(this.headType, null, this.p.getSkinParamBackcolored(this.skinParam), this.p.getDisplay(this.skinParam.forceSequenceParticipantUnderlined()));
        Dimension2D dimension2D = component.getPreferredDimension(uGraphic.getStringBounder());
        if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            uGraphic = uGraphic.apply(new UTranslate(-dimension2D.getWidth(), 0.0));
        }
        if (verticalAlignment == VerticalAlignment.CENTER) {
            uGraphic = uGraphic.apply(new UTranslate(0.0, -dimension2D.getHeight() / 2.0));
        }
        Area area = new Area(dimension2D);
        Url url = this.getParticipant().getUrl();
        if (url != null) {
            uGraphic.startUrl(url);
        }
        component.drawU(uGraphic, area, context2D);
        if (url != null) {
            uGraphic.closeAction();
        }
    }

    public Dimension2D getHeadPreferredDimension(StringBounder stringBounder) {
        Component component = this.rose.createComponent(this.headType, null, this.skinParam, this.p.getDisplay(this.skinParam.forceSequenceParticipantUnderlined()));
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        return dimension2D;
    }

    private double getPreferredWidth(StringBounder stringBounder) {
        return this.getHeadPreferredDimension(stringBounder).getWidth();
    }

    public Real getPosC(StringBounder stringBounder) {
        if (this.posC == null) {
            this.posC = this.posB.addFixed(this.getPreferredWidth(stringBounder) / 2.0);
        }
        return this.posC;
    }

    public Real getPosC2(StringBounder stringBounder) {
        double d = this.liveBoxes.getMaxPosition(stringBounder);
        return this.getPosC(stringBounder).addFixed(d);
    }

    public Real getPosD(StringBounder stringBounder) {
        if (this.posD == null) {
            this.posD = this.posB.addFixed(this.getPreferredWidth(stringBounder));
        }
        return this.posD;
    }

    public Real getPosB() {
        return this.posB;
    }

    public Participant getParticipant() {
        return this.p;
    }

    public void goCreate(double d) {
        System.err.println("LivingSpace::goCreate y=" + d);
        this.createY = d;
        this.create = true;
    }

    public void goCreate() {
        this.create = true;
    }

    public void delayOn(double d, double d2) {
        this.mutingLine.delayOn(d, d2);
        this.liveBoxes.delayOn(d, d2);
    }

    public ParticipantEnglober getEnglober() {
        return this.englober;
    }
}

