/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Delay;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Divider;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingLeaf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingStart;
import znaishaded.net.sourceforge.plantuml.sequencediagram.GroupingType;
import znaishaded.net.sourceforge.plantuml.sequencediagram.HSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.MessageExo;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteOnMessage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Notes;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Reference;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationExoTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteLeft;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileNoteRight;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelf;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.CommunicationTileSelfNoteRight;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.DelayTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.DividerTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.ElseTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EmptyTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.GroupingTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.HSpaceTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LifeEventTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpaces;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.NoteTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.NotesTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.ReferenceTile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Tile;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileArguments;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import znaishaded.net.sourceforge.plantuml.skin.Skin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TileBuilder {
    public static List<Tile> buildSeveral(Iterator<Event> iterator, TileArguments tileArguments, Tile tile) {
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        while (iterator.hasNext()) {
            Event event = iterator.next();
            for (Tile tile2 : TileBuilder.buildOne(iterator, tileArguments, event, tile)) {
                arrayList.add(tile2);
                Real real = tile2.getMaxX(tileArguments.getStringBounder());
            }
        }
        return Collections.unmodifiableList(arrayList);
    }

    public static List<Tile> buildOne(Iterator<Event> iterator, TileArguments tileArguments, Event event, Tile tile) {
        StringBounder stringBounder = tileArguments.getStringBounder();
        Skin skin = tileArguments.getSkin();
        ISkinParam iSkinParam = tileArguments.getSkinParam();
        LivingSpaces livingSpaces = tileArguments.getLivingSpaces();
        ArrayList<Tile> arrayList = new ArrayList<Tile>();
        if (event instanceof Message) {
            Message message = (Message)event;
            LivingSpace livingSpace = livingSpaces.get(message.getParticipant1());
            LivingSpace livingSpace2 = livingSpaces.get(message.getParticipant2());
            boolean bl = false;
            TileWithUpdateStairs tileWithUpdateStairs = null;
            if (message.isSelfMessage()) {
                tileWithUpdateStairs = new CommunicationTileSelf(livingSpace, message, skin, iSkinParam, livingSpaces);
            } else {
                tileWithUpdateStairs = new CommunicationTile(livingSpace, livingSpace2, message, skin, iSkinParam);
                bl = ((CommunicationTile)tileWithUpdateStairs).isReverse(stringBounder);
            }
            for (NoteOnMessage noteOnMessage : message.getNoteOnMessages()) {
                NotePosition notePosition = noteOnMessage.getNotePosition();
                if (notePosition == NotePosition.LEFT) {
                    tileWithUpdateStairs = new CommunicationTileNoteLeft(tileWithUpdateStairs, message, skin, iSkinParam, bl ? livingSpace2 : livingSpace, noteOnMessage);
                    continue;
                }
                if (notePosition == NotePosition.RIGHT && message.isSelfMessage()) {
                    tileWithUpdateStairs = new CommunicationTileSelfNoteRight((CommunicationTileSelf)tileWithUpdateStairs, message, skin, iSkinParam, noteOnMessage);
                    continue;
                }
                if (notePosition != NotePosition.RIGHT) continue;
                tileWithUpdateStairs = new CommunicationTileNoteRight(tileWithUpdateStairs, message, skin, iSkinParam, bl ? livingSpace : livingSpace2, noteOnMessage);
            }
            arrayList.add(tileWithUpdateStairs);
        } else if (event instanceof MessageExo) {
            MessageExo messageExo = (MessageExo)event;
            LivingSpace livingSpace = livingSpaces.get(messageExo.getParticipant());
            TileWithUpdateStairs tileWithUpdateStairs = null;
            tileWithUpdateStairs = new CommunicationExoTile(livingSpace, messageExo, skin, iSkinParam, tileArguments);
            for (NoteOnMessage noteOnMessage : messageExo.getNoteOnMessages()) {
                NotePosition notePosition = messageExo.getNoteOnMessages().get(0).getNotePosition();
                if (notePosition == NotePosition.LEFT) {
                    tileWithUpdateStairs = new CommunicationTileNoteLeft(tileWithUpdateStairs, messageExo, skin, iSkinParam, livingSpace, noteOnMessage);
                    continue;
                }
                if (notePosition != NotePosition.RIGHT) continue;
                tileWithUpdateStairs = new CommunicationTileNoteRight(tileWithUpdateStairs, messageExo, skin, iSkinParam, livingSpace, noteOnMessage);
            }
            arrayList.add(tileWithUpdateStairs);
        } else if (event instanceof Note) {
            Note note = (Note)event;
            LivingSpace livingSpace = livingSpaces.get(note.getParticipant());
            LivingSpace livingSpace3 = note.getParticipant2() == null ? null : livingSpaces.get(note.getParticipant2());
            arrayList.add(new NoteTile(livingSpace, livingSpace3, note, skin, iSkinParam));
        } else if (event instanceof Notes) {
            Notes notes = (Notes)event;
            arrayList.add(new NotesTile(livingSpaces, notes, skin, iSkinParam));
        } else if (event instanceof Divider) {
            Divider divider = (Divider)event;
            arrayList.add(new DividerTile(divider, tileArguments));
        } else if (event instanceof GroupingStart) {
            GroupingStart groupingStart = (GroupingStart)event;
            arrayList.add(new EmptyTile(4.0, tileArguments));
            arrayList.add(new GroupingTile(iterator, groupingStart, tileArguments.withBackColorGeneral(groupingStart.getBackColorElement(), groupingStart.getBackColorGeneral()), tileArguments));
            arrayList.add(new EmptyTile(4.0, tileArguments));
        } else if (event instanceof GroupingLeaf && ((GroupingLeaf)event).getType() == GroupingType.ELSE) {
            GroupingLeaf groupingLeaf = (GroupingLeaf)event;
            arrayList.add(new ElseTile(groupingLeaf, skin, iSkinParam, tile));
        } else if (event instanceof Reference) {
            Reference reference = (Reference)event;
            arrayList.add(new ReferenceTile(reference, tileArguments.withBackColor(reference)));
        } else if (event instanceof Delay) {
            Delay delay = (Delay)event;
            arrayList.add(new DelayTile(delay, tileArguments));
        } else if (event instanceof HSpace) {
            HSpace hSpace = (HSpace)event;
            arrayList.add(new HSpaceTile(hSpace, tileArguments));
        } else if (event instanceof LifeEvent) {
            LifeEvent lifeEvent = (LifeEvent)event;
            LivingSpace livingSpace = livingSpaces.get(lifeEvent.getParticipant());
            arrayList.add(new LifeEventTile(lifeEvent, tileArguments, livingSpace, skin, iSkinParam));
        } else {
            System.err.println("TileBuilder::Ignoring " + event.getClass());
        }
        return arrayList;
    }
}

