/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public final class RoundedContainer {
    private final Dimension2D dim;
    private final double titleHeight;
    private final double attributeHeight;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final HtmlColor imgBackcolor;
    private final UStroke stroke;

    public RoundedContainer(Dimension2D dimension2D, double d, double d2, HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UStroke uStroke) {
        this.dim = dimension2D;
        this.imgBackcolor = htmlColor3;
        this.titleHeight = d;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.attributeHeight = d2;
        this.stroke = uStroke;
    }

    public void drawU(UGraphic uGraphic, boolean bl) {
        uGraphic = uGraphic.apply(new UChangeBackColor(this.backColor)).apply(new UChangeColor(this.borderColor));
        URectangle uRectangle = new URectangle(this.dim.getWidth(), this.dim.getHeight(), 25.0, 25.0);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.apply(this.stroke).draw(uRectangle);
        double d = this.titleHeight + this.attributeHeight;
        uGraphic = uGraphic.apply(new UChangeBackColor(this.imgBackcolor));
        double d2 = this.stroke.getThickness();
        URectangle uRectangle2 = new URectangle(this.dim.getWidth() - 4.0 * d2, this.dim.getHeight() - this.titleHeight - 4.0 * d2 - this.attributeHeight, 25.0, 25.0);
        uGraphic.apply(new UChangeColor(this.imgBackcolor)).apply(new UTranslate(2.0 * d2, d + 2.0 * d2)).draw(uRectangle2);
        if (this.titleHeight > 0.0) {
            uGraphic.apply(this.stroke).apply(new UTranslate(0.0, d)).draw(new ULine(this.dim.getWidth(), 0.0));
        }
        if (this.attributeHeight > 0.0) {
            uGraphic.apply(this.stroke).apply(new UTranslate(0.0, d - this.attributeHeight)).draw(new ULine(this.dim.getWidth(), 0.0));
        }
    }
}

