/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.timingdiagram;

import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.timingdiagram.ChangeState;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Histogram;
import znaishaded.net.sourceforge.plantuml.timingdiagram.IntricatedPoint;
import znaishaded.net.sourceforge.plantuml.timingdiagram.Ribbon;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeConstraint;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeDrawing;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeProjected;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimeTick;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingRuler;
import znaishaded.net.sourceforge.plantuml.timingdiagram.TimingStyle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class Player
implements TextBlock,
TimeProjected {
    private final String code;
    private final Display full;
    private final TimingStyle type;
    private final ISkinParam skinParam;
    private final TimingRuler ruler;
    private String initialState;
    private final Set<ChangeState> changes = new TreeSet<ChangeState>();
    private final List<TimeConstraint> constraints = new ArrayList<TimeConstraint>();
    private TimeDrawing cached;
    private Colors initialColors;

    public Player(String string, String string2, TimingStyle timingStyle, ISkinParam iSkinParam, TimingRuler timingRuler) {
        this.code = string;
        this.full = Display.getWithNewlines(string2);
        this.type = timingStyle;
        this.skinParam = iSkinParam;
        this.ruler = timingRuler;
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.ACTIVITY, null);
    }

    public void drawU(UGraphic uGraphic) {
        TextBlock textBlock = this.getTitle();
        textBlock.drawU(uGraphic);
        Dimension2D dimension2D = textBlock.calculateDimension(uGraphic.getStringBounder());
        this.drawLine(uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK)).apply(new UStroke(1.0)), -5.0, dimension2D.getHeight() + 1.0, dimension2D.getWidth() + 1.0, dimension2D.getHeight() + 1.0, dimension2D.getWidth() + 1.0 + 10.0, 0.0);
    }

    public void drawContent(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(this.getTranslateForTimeDrawing(uGraphic.getStringBounder()));
        this.getTimeDrawing().drawU(uGraphic);
    }

    public void drawWidthHeader(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(this.getTranslateForTimeDrawing(uGraphic.getStringBounder()));
        this.getTimeDrawing().getWidthHeader(uGraphic.getStringBounder()).drawU(uGraphic);
    }

    public double getGetWidthHeader(StringBounder stringBounder) {
        return this.getTimeDrawing().getWidthHeader(stringBounder).calculateDimension(stringBounder).getWidth();
    }

    private void drawLine(UGraphic uGraphic, double ... dArray) {
        for (int i = 0; i < dArray.length - 2; i += 2) {
            double d = dArray[i];
            double d2 = dArray[i + 1];
            double d3 = dArray[i + 2];
            double d4 = dArray[i + 3];
            uGraphic.apply(new UTranslate(d, d2)).draw(new ULine(d3 - d, d4 - d2));
        }
    }

    private UTranslate getTranslateForTimeDrawing(StringBounder stringBounder) {
        TextBlock textBlock = this.getTitle();
        return new UTranslate(0.0, textBlock.calculateDimension(stringBounder).getHeight() * 2.0);
    }

    private TextBlock getTitle() {
        return this.full.create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
    }

    private TimeDrawing getTimeDrawing() {
        if (this.cached == null) {
            this.cached = this.computeTimeDrawing();
        }
        return this.cached;
    }

    private TimeDrawing computeTimeDrawing() {
        TimeDrawing timeDrawing;
        if (this.type == TimingStyle.CONCISE) {
            timeDrawing = new Ribbon(this.ruler, this.skinParam);
        } else if (this.type == TimingStyle.ROBUST) {
            timeDrawing = new Histogram(this.ruler, this.skinParam);
        } else {
            throw new IllegalStateException();
        }
        timeDrawing.setInitialState(this.initialState, this.initialColors);
        for (ChangeState object : this.changes) {
            timeDrawing.addChange(object);
        }
        for (TimeConstraint timeConstraint : this.constraints) {
            timeDrawing.addConstraint(timeConstraint);
        }
        return timeDrawing;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        TextBlock textBlock = this.getTitle();
        double d = this.ruler.getWidth();
        double d2 = this.getZoneHeight();
        return new Dimension2DDouble(d, textBlock.calculateDimension(stringBounder).getHeight() * 2.0 + d2);
    }

    private double getZoneHeight() {
        return this.getTimeDrawing().getHeight();
    }

    public Rectangle2D getInnerPosition(String string, StringBounder stringBounder, InnerStrategy innerStrategy) {
        return null;
    }

    public void setState(TimeTick timeTick, String string, String string2, Colors colors) {
        if (timeTick == null) {
            this.initialState = string;
            this.initialColors = colors;
        } else {
            if (string == null) {
                throw new IllegalArgumentException();
            }
            this.changes.add(new ChangeState(timeTick, string, string2, colors));
        }
    }

    public IntricatedPoint getTimeProjection(StringBounder stringBounder, TimeTick timeTick) {
        IntricatedPoint intricatedPoint = this.getTimeDrawing().getTimeProjection(stringBounder, timeTick);
        if (intricatedPoint == null) {
            return null;
        }
        UTranslate uTranslate = this.getTranslateForTimeDrawing(stringBounder);
        return intricatedPoint.translated(uTranslate);
    }

    public void createConstraint(TimeTick timeTick, TimeTick timeTick2, String string) {
        this.constraints.add(new TimeConstraint(timeTick, timeTick2, string));
    }
}

