/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.turing;

import znaishaded.net.sourceforge.plantuml.turing.BFToken;

public class BFMachine {
    private final char[] cells = new char[30000];
    private final BFToken[] prg;
    private int prgPointer;
    private int pointer;
    private final StringBuilder output = new StringBuilder();
    private final String input;
    private int inputPointer;

    public BFMachine(String string, String string2) {
        this.prg = new BFToken[string.length() + 1];
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            BFToken bFToken = BFToken.getToken(string.charAt(i));
            if (bFToken == null) continue;
            this.prg[n++] = bFToken;
        }
        this.input = string2;
    }

    public boolean run() {
        for (int i = 0; i < 10000000; ++i) {
            if (this.prg[this.prgPointer] == null) {
                return true;
            }
            this.interpret(this.prg[this.prgPointer]);
            ++this.prgPointer;
        }
        return false;
    }

    private void interpret(BFToken bFToken) {
        switch (bFToken) {
            case NEXT: {
                ++this.pointer;
                break;
            }
            case PREVIOUS: {
                --this.pointer;
                break;
            }
            case PLUS: {
                int n = this.pointer;
                this.cells[n] = (char)(this.cells[n] + '\u0001');
                break;
            }
            case MINUS: {
                int n = this.pointer;
                this.cells[n] = (char)(this.cells[n] - '\u0001');
                break;
            }
            case OUTPUT: {
                this.output(this.cells[this.pointer]);
                break;
            }
            case INPUT: {
                int n = this.input();
                if (n == -1) break;
                this.cells[this.pointer] = (char)n;
                break;
            }
            case BRACKET_LEFT: {
                if (this.cells[this.pointer] != '\u0000') break;
                int n = 1;
                while (n > 0) {
                    BFToken bFToken2;
                    if ((bFToken2 = this.prg[++this.prgPointer]) == BFToken.BRACKET_LEFT) {
                        ++n;
                        continue;
                    }
                    if (bFToken2 != BFToken.BRACKET_RIGHT) continue;
                    --n;
                }
                break;
            }
            case BRACKET_RIGHT: {
                int n = 1;
                while (n > 0) {
                    BFToken bFToken3;
                    if ((bFToken3 = this.prg[--this.prgPointer]) == BFToken.BRACKET_LEFT) {
                        --n;
                        continue;
                    }
                    if (bFToken3 != BFToken.BRACKET_RIGHT) continue;
                    ++n;
                }
                --this.prgPointer;
            }
        }
    }

    private int input() {
        if (this.inputPointer < this.input.length()) {
            return this.input.charAt(this.inputPointer++);
        }
        return -1;
    }

    private void output(char c) {
        this.output.append(c);
    }

    public String getOutput() {
        return this.output.toString();
    }
}

