/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.xmlsc;

import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.statediagram.StateDiagram;

public class ScxmlStateDiagramStandard {
    private final StateDiagram diagram;
    private final Document document;

    public ScxmlStateDiagramStandard(StateDiagram stateDiagram) throws ParserConfigurationException {
        this.diagram = stateDiagram;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        this.document = documentBuilder.newDocument();
        this.document.setXmlVersion("1.0");
        this.document.setXmlStandalone(true);
        Element element = this.document.createElement("scxml");
        element.setAttribute("xmlns", "http://www.w3.org/2005/07/scxml");
        element.setAttribute("version", "1.0");
        String string = this.getInitial();
        if (string != null) {
            element.setAttribute("initial", string);
        }
        this.document.appendChild(element);
        for (IEntity iEntity : stateDiagram.getLeafsvalues()) {
            element.appendChild(this.createState(iEntity));
        }
    }

    private String getInitial() {
        for (IEntity iEntity : this.diagram.getLeafsvalues()) {
            if (iEntity.getLeafType() != LeafType.CIRCLE_START) continue;
            return this.getId(iEntity);
        }
        return null;
    }

    private Element createState(IEntity iEntity) {
        Element element = this.document.createElement("state");
        element.setAttribute("id", this.getId(iEntity));
        for (Link link : this.diagram.getLinks()) {
            if (link.getEntity1() != iEntity) continue;
            this.addLink(element, link);
        }
        return element;
    }

    private void addLink(Element element, Link link) {
        Element element2 = this.document.createElement("transition");
        Display display = link.getLabel();
        if (!Display.isNull(display)) {
            String string = display.get(0).toString();
            element2.setAttribute("event", string);
        }
        element2.setAttribute("target", this.getId(link.getEntity2()));
        element.appendChild(element2);
    }

    private String getId(IEntity iEntity) {
        String string = iEntity.getDisplay().get(0).toString();
        string = string.replaceAll("\\*", "");
        return string;
    }

    public void transformerXml(OutputStream outputStream) throws TransformerException, ParserConfigurationException {
        DOMSource dOMSource = new DOMSource(this.document);
        StreamResult streamResult = new StreamResult(outputStream);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.transform(dOMSource, streamResult);
    }
}

