/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.antlr.v4.tool;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import znaishaded.org.antlr.v4.misc.Utils;
import znaishaded.org.antlr.v4.runtime.atn.ATNConfig;
import znaishaded.org.antlr.v4.runtime.atn.ATNConfigSet;
import znaishaded.org.antlr.v4.runtime.atn.ATNState;
import znaishaded.org.antlr.v4.runtime.atn.AbstractPredicateTransition;
import znaishaded.org.antlr.v4.runtime.atn.ActionTransition;
import znaishaded.org.antlr.v4.runtime.atn.AtomTransition;
import znaishaded.org.antlr.v4.runtime.atn.BlockEndState;
import znaishaded.org.antlr.v4.runtime.atn.BlockStartState;
import znaishaded.org.antlr.v4.runtime.atn.DecisionState;
import znaishaded.org.antlr.v4.runtime.atn.NotSetTransition;
import znaishaded.org.antlr.v4.runtime.atn.PlusBlockStartState;
import znaishaded.org.antlr.v4.runtime.atn.PlusLoopbackState;
import znaishaded.org.antlr.v4.runtime.atn.RangeTransition;
import znaishaded.org.antlr.v4.runtime.atn.RuleStartState;
import znaishaded.org.antlr.v4.runtime.atn.RuleStopState;
import znaishaded.org.antlr.v4.runtime.atn.RuleTransition;
import znaishaded.org.antlr.v4.runtime.atn.SetTransition;
import znaishaded.org.antlr.v4.runtime.atn.StarBlockStartState;
import znaishaded.org.antlr.v4.runtime.atn.StarLoopEntryState;
import znaishaded.org.antlr.v4.runtime.atn.StarLoopbackState;
import znaishaded.org.antlr.v4.runtime.atn.Transition;
import znaishaded.org.antlr.v4.runtime.dfa.DFA;
import znaishaded.org.antlr.v4.runtime.dfa.DFAState;
import znaishaded.org.antlr.v4.runtime.misc.IntegerList;
import znaishaded.org.antlr.v4.tool.Grammar;
import znaishaded.org.stringtemplate.v4.ST;
import znaishaded.org.stringtemplate.v4.STGroup;
import znaishaded.org.stringtemplate.v4.STGroupFile;

public class DOTGenerator {
    public static final boolean STRIP_NONREDUCED_STATES = false;
    protected String arrowhead = "normal";
    protected String rankdir = "LR";
    public static STGroup stlib = new STGroupFile("znaishaded/org/antlr/v4/tool/templates/dot/graphs.stg");
    protected Grammar grammar;

    public DOTGenerator(Grammar grammar) {
        this.grammar = grammar;
    }

    public String getDOT(DFA dfa, boolean isLexer) {
        ST st;
        if (dfa.s0 == null) {
            return null;
        }
        ST dot = stlib.getInstanceOf("dfa");
        dot.add("name", "DFA" + dfa.decision);
        dot.add("startState", dfa.s0.stateNumber);
        dot.add("rankdir", this.rankdir);
        for (DFAState d : dfa.states.keySet()) {
            if (!d.isAcceptState) continue;
            st = stlib.getInstanceOf("stopstate");
            st.add("name", "s" + d.stateNumber);
            st.add("label", this.getStateLabel(d));
            dot.add("states", st);
        }
        for (DFAState d : dfa.states.keySet()) {
            if (d.isAcceptState || d.stateNumber == Integer.MAX_VALUE) continue;
            st = stlib.getInstanceOf("state");
            st.add("name", "s" + d.stateNumber);
            st.add("label", this.getStateLabel(d));
            dot.add("states", st);
        }
        for (DFAState d : dfa.states.keySet()) {
            if (d.edges == null) continue;
            for (int i = 0; i < d.edges.length; ++i) {
                DFAState target = d.edges[i];
                if (target == null || target.stateNumber == Integer.MAX_VALUE) continue;
                int ttype = i - 1;
                String label = String.valueOf(ttype);
                if (isLexer) {
                    label = "'" + this.getEdgeLabel(String.valueOf((char)i)) + "'";
                } else if (this.grammar != null) {
                    label = this.grammar.getTokenDisplayName(ttype);
                }
                ST st2 = stlib.getInstanceOf("edge");
                st2.add("label", label);
                st2.add("src", "s" + d.stateNumber);
                st2.add("target", "s" + target.stateNumber);
                st2.add("arrowhead", this.arrowhead);
                dot.add("edges", st2);
            }
        }
        String output = dot.render();
        return Utils.sortLinesInString(output);
    }

    protected String getStateLabel(DFAState s2) {
        Set<Integer> alts;
        if (s2 == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder(250);
        buf.append('s');
        buf.append(s2.stateNumber);
        if (s2.isAcceptState) {
            buf.append("=>").append(s2.prediction);
        }
        if (s2.requiresFullContext) {
            buf.append("^");
        }
        if (this.grammar != null && (alts = s2.getAltSet()) != null) {
            buf.append("\\n");
            IntegerList altList = new IntegerList();
            altList.addAll(alts);
            altList.sort();
            ATNConfigSet configurations = s2.configs;
            for (int altIndex = 0; altIndex < altList.size(); ++altIndex) {
                int alt = altList.get(altIndex);
                if (altIndex > 0) {
                    buf.append("\\n");
                }
                buf.append("alt");
                buf.append(alt);
                buf.append(':');
                ArrayList<ATNConfig> configsInAlt = new ArrayList<ATNConfig>();
                for (ATNConfig c : configurations) {
                    if (c.alt != alt) continue;
                    configsInAlt.add(c);
                }
                int n = 0;
                for (int cIndex = 0; cIndex < configsInAlt.size(); ++cIndex) {
                    ATNConfig c = (ATNConfig)configsInAlt.get(cIndex);
                    ++n;
                    buf.append(c.toString(null, false));
                    if (cIndex + 1 < configsInAlt.size()) {
                        buf.append(", ");
                    }
                    if (n % 5 != 0 || configsInAlt.size() - cIndex <= 3) continue;
                    buf.append("\\n");
                }
            }
        }
        String stateLabel = buf.toString();
        return stateLabel;
    }

    public String getDOT(ATNState startState) {
        return this.getDOT(startState, false);
    }

    public String getDOT(ATNState startState, boolean isLexer) {
        Set ruleNames = this.grammar.rules.keySet();
        String[] names = new String[ruleNames.size() + 1];
        int i = 0;
        for (String s2 : ruleNames) {
            names[i++] = s2;
        }
        return this.getDOT(startState, names, isLexer);
    }

    public String getDOT(ATNState startState, String[] ruleNames, boolean isLexer) {
        if (startState == null) {
            return null;
        }
        HashSet<ATNState> markedStates = new HashSet<ATNState>();
        ST dot = stlib.getInstanceOf("atn");
        dot.add("startState", startState.stateNumber);
        dot.add("rankdir", this.rankdir);
        LinkedList<ATNState> work = new LinkedList<ATNState>();
        work.add(startState);
        while (!work.isEmpty()) {
            ATNState s2 = (ATNState)work.get(0);
            if (markedStates.contains(s2)) {
                work.remove(0);
                continue;
            }
            markedStates.add(s2);
            if (s2 instanceof RuleStopState) continue;
            for (int i = 0; i < s2.getNumberOfTransitions(); ++i) {
                String label;
                ST edgeST;
                Transition edge = s2.transition(i);
                if (edge instanceof RuleTransition) {
                    RuleTransition rr = (RuleTransition)edge;
                    edgeST = stlib.getInstanceOf("edge");
                    label = "<" + ruleNames[rr.ruleIndex];
                    if (((RuleStartState)rr.target).isPrecedenceRule) {
                        label = label + "[" + rr.precedence + "]";
                    }
                    label = label + ">";
                    edgeST.add("label", label);
                    edgeST.add("src", "s" + s2.stateNumber);
                    edgeST.add("target", "s" + rr.followState.stateNumber);
                    edgeST.add("arrowhead", this.arrowhead);
                    dot.add("edges", edgeST);
                    work.add(rr.followState);
                    continue;
                }
                if (edge instanceof ActionTransition) {
                    edgeST = stlib.getInstanceOf("action-edge");
                    edgeST.add("label", this.getEdgeLabel(edge.toString()));
                } else if (edge instanceof AbstractPredicateTransition) {
                    edgeST = stlib.getInstanceOf("edge");
                    edgeST.add("label", this.getEdgeLabel(edge.toString()));
                } else if (edge.isEpsilon()) {
                    edgeST = stlib.getInstanceOf("epsilon-edge");
                    edgeST.add("label", this.getEdgeLabel(edge.toString()));
                    boolean loopback = false;
                    if (edge.target instanceof PlusBlockStartState) {
                        loopback = s2.equals(((PlusBlockStartState)edge.target).loopBackState);
                    } else if (edge.target instanceof StarLoopEntryState) {
                        loopback = s2.equals(((StarLoopEntryState)edge.target).loopBackState);
                    }
                    edgeST.add("loopback", loopback);
                } else if (edge instanceof AtomTransition) {
                    edgeST = stlib.getInstanceOf("edge");
                    AtomTransition atom = (AtomTransition)edge;
                    label = String.valueOf(atom.label);
                    if (isLexer) {
                        label = "'" + this.getEdgeLabel(String.valueOf((char)atom.label)) + "'";
                    } else if (this.grammar != null) {
                        label = this.grammar.getTokenDisplayName(atom.label);
                    }
                    edgeST.add("label", this.getEdgeLabel(label));
                } else if (edge instanceof SetTransition) {
                    edgeST = stlib.getInstanceOf("edge");
                    SetTransition set = (SetTransition)edge;
                    label = set.label().toString();
                    if (isLexer) {
                        label = set.label().toString(true);
                    } else if (this.grammar != null) {
                        label = set.label().toString(this.grammar.getVocabulary());
                    }
                    if (edge instanceof NotSetTransition) {
                        label = "~" + label;
                    }
                    edgeST.add("label", this.getEdgeLabel(label));
                } else if (edge instanceof RangeTransition) {
                    edgeST = stlib.getInstanceOf("edge");
                    RangeTransition range = (RangeTransition)edge;
                    label = range.label().toString();
                    if (isLexer) {
                        label = range.toString();
                    } else if (this.grammar != null) {
                        label = range.label().toString(this.grammar.getVocabulary());
                    }
                    edgeST.add("label", this.getEdgeLabel(label));
                } else {
                    edgeST = stlib.getInstanceOf("edge");
                    edgeST.add("label", this.getEdgeLabel(edge.toString()));
                }
                edgeST.add("src", "s" + s2.stateNumber);
                edgeST.add("target", "s" + edge.target.stateNumber);
                edgeST.add("arrowhead", this.arrowhead);
                if (s2.getNumberOfTransitions() > 1) {
                    edgeST.add("transitionIndex", i);
                } else {
                    edgeST.add("transitionIndex", false);
                }
                dot.add("edges", edgeST);
                work.add(edge.target);
            }
        }
        for (ATNState s3 : markedStates) {
            if (!(s3 instanceof RuleStopState)) continue;
            ST st = stlib.getInstanceOf("stopstate");
            st.add("name", "s" + s3.stateNumber);
            st.add("label", this.getStateLabel(s3));
            dot.add("states", st);
        }
        for (ATNState s3 : markedStates) {
            if (s3 instanceof RuleStopState) continue;
            ST st = stlib.getInstanceOf("state");
            st.add("name", "s" + s3.stateNumber);
            st.add("label", this.getStateLabel(s3));
            st.add("transitions", s3.getTransitions());
            dot.add("states", st);
        }
        return dot.render();
    }

    protected String getEdgeLabel(String label) {
        label = label.replace("\\", "\\\\");
        label = label.replace("\"", "\\\"");
        label = label.replace("\n", "\\\\n");
        label = label.replace("\r", "");
        return label;
    }

    protected String getStateLabel(ATNState s2) {
        if (s2 == null) {
            return "null";
        }
        String stateLabel = "";
        if (s2 instanceof BlockStartState) {
            stateLabel = stateLabel + "&rarr;\\n";
        } else if (s2 instanceof BlockEndState) {
            stateLabel = stateLabel + "&larr;\\n";
        }
        stateLabel = stateLabel + String.valueOf(s2.stateNumber);
        if (s2 instanceof PlusBlockStartState || s2 instanceof PlusLoopbackState) {
            stateLabel = stateLabel + "+";
        } else if (s2 instanceof StarBlockStartState || s2 instanceof StarLoopEntryState || s2 instanceof StarLoopbackState) {
            stateLabel = stateLabel + "*";
        }
        if (s2 instanceof DecisionState && ((DecisionState)s2).decision >= 0) {
            stateLabel = stateLabel + "\\nd=" + ((DecisionState)s2).decision;
        }
        return stateLabel;
    }
}

