/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.util;

import java.io.IOException;
import znaishaded.org.apache.ant.compress.util.ArchiveStreamFactory;
import znaishaded.org.apache.ant.compress.util.CompressorStreamFactory;
import znaishaded.org.apache.ant.compress.util.FileAwareArchiveStreamFactory;
import znaishaded.org.apache.ant.compress.util.FileAwareCompressorStreamFactory;
import znaishaded.org.apache.commons.compress.archivers.ArchiveInputStream;
import znaishaded.org.apache.commons.compress.archivers.ArchiveOutputStream;
import znaishaded.org.apache.commons.compress.compressors.CompressorInputStream;
import znaishaded.org.apache.commons.compress.compressors.CompressorOutputStream;
import znaishaded.org.apache.tools.ant.types.Resource;
import znaishaded.org.apache.tools.ant.types.resources.FileProvider;

public class StreamHelper {
    private StreamHelper() {
    }

    private static boolean isFileCombination(ArchiveStreamFactory factory, Resource r) {
        return factory instanceof FileAwareArchiveStreamFactory && r.as(FileProvider.class) != null;
    }

    private static boolean isFileCombination(CompressorStreamFactory factory, Resource r) {
        return factory instanceof FileAwareCompressorStreamFactory && r.as(FileProvider.class) != null;
    }

    public static ArchiveInputStream getInputStream(ArchiveStreamFactory factory, Resource r, String encoding) throws IOException {
        if (StreamHelper.isFileCombination(factory, r)) {
            FileProvider p = r.as(FileProvider.class);
            FileAwareArchiveStreamFactory f = (FileAwareArchiveStreamFactory)factory;
            return f.getArchiveInputStream(p.getFile(), encoding);
        }
        return null;
    }

    public static ArchiveOutputStream getOutputStream(ArchiveStreamFactory factory, Resource r, String encoding) throws IOException {
        if (StreamHelper.isFileCombination(factory, r)) {
            FileProvider p = r.as(FileProvider.class);
            FileAwareArchiveStreamFactory f = (FileAwareArchiveStreamFactory)factory;
            return f.getArchiveOutputStream(p.getFile(), encoding);
        }
        return null;
    }

    public static CompressorInputStream getInputStream(CompressorStreamFactory factory, Resource r) throws IOException {
        if (StreamHelper.isFileCombination(factory, r)) {
            FileProvider p = r.as(FileProvider.class);
            FileAwareCompressorStreamFactory f = (FileAwareCompressorStreamFactory)factory;
            return f.getCompressorInputStream(p.getFile());
        }
        return null;
    }

    public static CompressorOutputStream getOutputStream(CompressorStreamFactory factory, Resource r) throws IOException {
        if (StreamHelper.isFileCombination(factory, r)) {
            FileProvider p = r.as(FileProvider.class);
            FileAwareCompressorStreamFactory f = (FileAwareCompressorStreamFactory)factory;
            return f.getCompressorOutputStream(p.getFile());
        }
        return null;
    }
}

