/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.http.cookie;

import java.io.Serializable;
import java.util.Comparator;
import znaishaded.org.apache.http.annotation.Contract;
import znaishaded.org.apache.http.annotation.ThreadingBehavior;
import znaishaded.org.apache.http.cookie.Cookie;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class CookiePathComparator
implements Serializable,
Comparator<Cookie> {
    public static final CookiePathComparator INSTANCE = new CookiePathComparator();
    private static final long serialVersionUID = 7523645369616405818L;

    private String normalizePath(Cookie cookie) {
        String path2 = cookie.getPath();
        if (path2 == null) {
            path2 = "/";
        }
        if (!path2.endsWith("/")) {
            path2 = path2 + '/';
        }
        return path2;
    }

    @Override
    public int compare(Cookie c1, Cookie c2) {
        String path2;
        String path1 = this.normalizePath(c1);
        if (path1.equals(path2 = this.normalizePath(c2))) {
            return 0;
        }
        if (path1.startsWith(path2)) {
            return -1;
        }
        if (path2.startsWith(path1)) {
            return 1;
        }
        return 0;
    }
}

