/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.tools.ant.taskdefs.optional.jsp.compilers;

import znaishaded.org.apache.tools.ant.AntClassLoader;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.Task;
import znaishaded.org.apache.tools.ant.taskdefs.optional.jsp.Jasper41Mangler;
import znaishaded.org.apache.tools.ant.taskdefs.optional.jsp.JspNameMangler;
import znaishaded.org.apache.tools.ant.taskdefs.optional.jsp.compilers.JasperC;
import znaishaded.org.apache.tools.ant.taskdefs.optional.jsp.compilers.JspCompilerAdapter;

public final class JspCompilerAdapterFactory {
    private JspCompilerAdapterFactory() {
    }

    public static JspCompilerAdapter getCompiler(String compilerType, Task task) throws BuildException {
        return JspCompilerAdapterFactory.getCompiler(compilerType, task, task.getProject().createClassLoader(null));
    }

    public static JspCompilerAdapter getCompiler(String compilerType, Task task, AntClassLoader loader) throws BuildException {
        if ("jasper".equalsIgnoreCase(compilerType)) {
            return new JasperC(new JspNameMangler());
        }
        if ("jasper41".equalsIgnoreCase(compilerType)) {
            return new JasperC(new Jasper41Mangler());
        }
        return JspCompilerAdapterFactory.resolveClassName(compilerType, loader);
    }

    private static JspCompilerAdapter resolveClassName(String className, AntClassLoader classloader) throws BuildException {
        try {
            Class<JspCompilerAdapter> c = classloader.findClass(className).asSubclass(JspCompilerAdapter.class);
            return c.newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new BuildException(className + " can't be found.", cnfe);
        }
        catch (ClassCastException cce) {
            throw new BuildException(className + " isn't the classname of a compiler adapter.", cce);
        }
        catch (Throwable t) {
            throw new BuildException(className + " caused an interesting exception.", t);
        }
    }
}

