/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal.util;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.org.commonmark.internal.util.Html5Entities;

public class Escaping {
    public static final String ESCAPABLE = "[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    private static final String ENTITY = "&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});", 2);
    private static final String XML_SPECIAL = "[&<>\"]";
    private static final Pattern XML_SPECIAL_RE = Pattern.compile("[&<>\"]");
    private static final Pattern XML_SPECIAL_OR_ENTITY = Pattern.compile("&(?:#x[a-f0-9]{1,8}|#[0-9]{1,8}|[a-z][a-z0-9]{1,31});|[&<>\"]", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Replacer UNSAFE_CHAR_REPLACER = new Replacer(){

        @Override
        public void replace(String input, StringBuilder sb) {
            switch (input) {
                case "&": {
                    sb.append("&amp;");
                    break;
                }
                case "<": {
                    sb.append("&lt;");
                    break;
                }
                case ">": {
                    sb.append("&gt;");
                    break;
                }
                case "\"": {
                    sb.append("&quot;");
                    break;
                }
                default: {
                    sb.append(input);
                }
            }
        }
    };
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(String input, StringBuilder sb) {
            if (input.charAt(0) == '\\') {
                sb.append(input, 1, input.length());
            } else {
                sb.append(Html5Entities.entityToString(input));
            }
        }
    };
    private static final Replacer URI_REPLACER = new Replacer(){

        @Override
        public void replace(String input, StringBuilder sb) {
            if (input.startsWith("%")) {
                if (input.length() == 3) {
                    sb.append(input);
                } else {
                    sb.append("%25");
                    sb.append(input, 1, input.length());
                }
            } else {
                byte[] bytes;
                for (byte b : bytes = input.getBytes(Charset.forName("UTF-8"))) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b & 0xF]);
                }
            }
        }
    };

    public static String escapeHtml(String input, boolean preserveEntities) {
        Pattern p = preserveEntities ? XML_SPECIAL_OR_ENTITY : XML_SPECIAL_RE;
        return Escaping.replaceAll(p, input, UNSAFE_CHAR_REPLACER);
    }

    public static String unescapeString(String s2) {
        if (BACKSLASH_OR_AMP.matcher(s2).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s2, UNESCAPE_REPLACER);
        }
        return s2;
    }

    public static String percentEncodeUrl(String s2) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s2, URI_REPLACER);
    }

    public static String normalizeReference(String input) {
        String stripped = input.substring(1, input.length() - 1).trim();
        String lowercase = stripped.toLowerCase(Locale.ROOT);
        return WHITESPACE.matcher(lowercase).replaceAll(" ");
    }

    private static String replaceAll(Pattern p, String s2, Replacer replacer) {
        Matcher matcher = p.matcher(s2);
        if (!matcher.find()) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s2, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s2.length()) {
            sb.append(s2, lastEnd, s2.length());
        }
        return sb.toString();
    }

    private static interface Replacer {
        public void replace(String var1, StringBuilder var2);
    }
}

