/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.testingisdocumenting.webtau.Matchers;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.extensions.include.PluginsTestUtils;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileIncludePluginTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileIncludePluginTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void should extract file snippet based on start line and number of lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', numberOfLines: 2}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', numberOfLines: 2}");
            text = string;
        }
        callSiteArray[1].call(text, callSiteArray[2].callStatic(WebTauCore.class, callSiteArray[3].call((Object)"a multiple lines\n", (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[4].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', endLine: 'stop'}");
            text = string;
        }
        callSiteArray[5].call(text, callSiteArray[6].callStatic(WebTauCore.class, callSiteArray[7].call(callSiteArray[8].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines excluding them() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[9].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[10].call(text, callSiteArray[11].callStatic(WebTauCore.class, (Object)""));
    }

    @Test
    public void should extract file snippet based on start line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[12].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines'}");
            text = string;
        }
        callSiteArray[13].call(text, callSiteArray[14].callStatic(WebTauCore.class, callSiteArray[15].call(callSiteArray[16].call(callSiteArray[17].call(callSiteArray[18].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on end line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[19].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: 'stop'}");
            text = string;
        }
        callSiteArray[20].call(text, callSiteArray[21].callStatic(WebTauCore.class, callSiteArray[22].call(callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should automatically strip extra indentation() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[26].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{startLine: 'class', endLine: '}', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{startLine: 'class', endLine: '}', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[27].call(text, callSiteArray[28].callStatic(WebTauCore.class, callSiteArray[29].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should only include lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object singleImport = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            singleImport = object = callSiteArray[30].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import.*ClassName'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import.*ClassName'}");
            singleImport = string;
        }
        callSiteArray[31].call(singleImport, callSiteArray[32].callStatic(WebTauCore.class, (Object)"import a.b.c.ClassName"));
        Object allImports = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            allImports = object = callSiteArray[33].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import'}");
            allImports = string;
        }
        callSiteArray[34].call(allImports, callSiteArray[35].callStatic(WebTauCore.class, callSiteArray[36].call((Object)"import e.d.g.AnotherName\n", (Object)"import a.b.c.ClassName")));
    }

    @Test
    public void should only include lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[37].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: ['int', 'def']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: ['int', 'def']}");
            result = string;
        }
        callSiteArray[38].call(result, callSiteArray[39].callStatic(WebTauCore.class, callSiteArray[40].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should exclude lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[41].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{excludeRegexp: '# exa..le'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{excludeRegexp: '# exa..le'}");
            withoutMarkers = string;
        }
        callSiteArray[42].call(withoutMarkers, callSiteArray[43].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should exclude lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[44].callStatic(FileIncludePluginTest.class, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-multi-marker.py", "{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
            withoutMarkers = string;
        }
        callSiteArray[45].call(withoutMarkers, callSiteArray[46].callStatic(WebTauCore.class, callSiteArray[47].call(callSiteArray[48].call((Object)"print(\"hello\")\n", (Object)"\n"), (Object)"print(\"hello world\")")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a line idx() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[49].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 3}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 3}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1.$getCallSiteArray();
                return callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 7}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[50].call(callSiteArray[51].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure1(this, this)), callSiteArray[52].callStatic(Matchers.class, callSiteArray[53].call((Object)"highlight idx is out of range: 7\n", (Object)"check: script.groovy")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[54].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'def a'}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 'def a'}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2.$getCallSiteArray();
                return callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'def c'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[55].call(callSiteArray[56].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure2(this, this)), callSiteArray[57].callStatic(Matchers.class, callSiteArray[58].call(callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call((Object)"highlight text <def c> is not found\n", (Object)"check: script.groovy\n"), (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should highlight lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[66].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'class'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'class'}");
            props = map;
        }
        callSiteArray[67].call(callSiteArray[68].callGetProperty(props), callSiteArray[69].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{3})));
    }

    @Test
    public void should highlight lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[70].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlightPath: 'highlight.txt'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlightPath: 'highlight.txt'}");
            props = map;
        }
        callSiteArray[71].call(callSiteArray[72].callGetProperty(props), callSiteArray[73].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{4, 5})));
    }

    @Test
    public void should validate lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_lines_from_a_highlight_text_file_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_lines_from_a_highlight_text_file_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure3.$getCallSiteArray();
                return callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlightPath: 'missing-highlight.txt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_lines_from_a_highlight_text_file_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingProps";
                return new CallSiteArray(_should_validate_lines_from_a_highlight_text_file_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[74].call(callSiteArray[75].callStatic(Matchers.class, (Object)new _should_validate_lines_from_a_highlight_text_file_closure3(this, this)), callSiteArray[76].callStatic(Matchers.class, ScriptBytecodeAdapter.bitwiseNegate((Object)"highlight text <def g> is not found")));
    }

    private static String resultingSnippet(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[77].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})));
    }

    private static Map<String, Object> resultingProps(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[78].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileIncludePluginTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "resultingSnippet";
        stringArray[1] = "should";
        stringArray[2] = "equal";
        stringArray[3] = "plus";
        stringArray[4] = "resultingSnippet";
        stringArray[5] = "should";
        stringArray[6] = "equal";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "resultingSnippet";
        stringArray[10] = "should";
        stringArray[11] = "equal";
        stringArray[12] = "resultingSnippet";
        stringArray[13] = "should";
        stringArray[14] = "equal";
        stringArray[15] = "plus";
        stringArray[16] = "plus";
        stringArray[17] = "plus";
        stringArray[18] = "plus";
        stringArray[19] = "resultingSnippet";
        stringArray[20] = "should";
        stringArray[21] = "equal";
        stringArray[22] = "plus";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "resultingSnippet";
        stringArray[27] = "should";
        stringArray[28] = "equal";
        stringArray[29] = "plus";
        stringArray[30] = "resultingSnippet";
        stringArray[31] = "should";
        stringArray[32] = "equal";
        stringArray[33] = "resultingSnippet";
        stringArray[34] = "should";
        stringArray[35] = "equal";
        stringArray[36] = "plus";
        stringArray[37] = "resultingSnippet";
        stringArray[38] = "should";
        stringArray[39] = "equal";
        stringArray[40] = "plus";
        stringArray[41] = "resultingSnippet";
        stringArray[42] = "should";
        stringArray[43] = "equal";
        stringArray[44] = "resultingSnippet";
        stringArray[45] = "should";
        stringArray[46] = "equal";
        stringArray[47] = "plus";
        stringArray[48] = "plus";
        stringArray[49] = "resultingSnippet";
        stringArray[50] = "should";
        stringArray[51] = "code";
        stringArray[52] = "throwException";
        stringArray[53] = "plus";
        stringArray[54] = "resultingSnippet";
        stringArray[55] = "should";
        stringArray[56] = "code";
        stringArray[57] = "throwException";
        stringArray[58] = "plus";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "plus";
        stringArray[65] = "plus";
        stringArray[66] = "resultingProps";
        stringArray[67] = "should";
        stringArray[68] = "highlight";
        stringArray[69] = "equal";
        stringArray[70] = "resultingProps";
        stringArray[71] = "should";
        stringArray[72] = "highlight";
        stringArray[73] = "equal";
        stringArray[74] = "should";
        stringArray[75] = "code";
        stringArray[76] = "throwException";
        stringArray[77] = "processAndGetSimplifiedCodeBlock";
        stringArray[78] = "processAndGetProps";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[79];
        FileIncludePluginTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileIncludePluginTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileIncludePluginTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

