/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.anim;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.anim.AffineTransformation;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;

public class Animation {
    private final List<AffineTransformation> all;

    private Animation(List<AffineTransformation> all) {
        if (all.size() == 0) {
            throw new IllegalArgumentException();
        }
        this.all = all;
    }

    public static Animation singleton(AffineTransformation affineTransformation) {
        if (affineTransformation == null) {
            return null;
        }
        return new Animation(Collections.singletonList(affineTransformation));
    }

    public static Animation create(List<String> descriptions) {
        ArrayList<AffineTransformation> all = new ArrayList<AffineTransformation>();
        for (String s2 : descriptions) {
            AffineTransformation tmp = AffineTransformation.create(s2);
            if (tmp == null) continue;
            all.add(tmp);
        }
        return new Animation(all);
    }

    public Collection<AffineTransformation> getAll() {
        return Collections.unmodifiableCollection(this.all);
    }

    public void setDimension(Dimension2D dim) {
        for (AffineTransformation affineTransform : this.all) {
            affineTransform.setDimension(dim);
        }
    }

    public AffineTransformation getFirst() {
        return this.all.get(0);
    }

    public MinMax getMinMax(Dimension2D dim) {
        MinMax result = MinMax.getEmpty(false);
        for (AffineTransformation affineTransform : this.all) {
            MinMax m3 = affineTransform.getMinMax(dim);
            result = result.addMinMax(m3);
        }
        return result;
    }
}

