/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextDelay
extends AbstractComponentText {
    private final Display stringsToDisplay;

    public ComponentTextDelay(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.stringsToDisplay = stringsToDisplay;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int textWidth = StringUtils.getWcWidth(this.stringsToDisplay);
        int textPos = (width - textWidth) / 2;
        if (this.stringsToDisplay.isWhite()) {
            return;
        }
        String desc = this.stringsToDisplay.get(0).toString();
        charArea.drawStringLR(desc, textPos, 1);
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 4;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

