/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.asciiart;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.asciiart.AbstractComponentText;
import znaishaded.net.sourceforge.plantuml.asciiart.UmlCharArea;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.txt.UGraphicTxt;

public class ComponentTextGroupingHeader
extends AbstractComponentText {
    private final ComponentType type;
    private final Display stringsToDisplay;
    private final FileFormat fileFormat;

    public ComponentTextGroupingHeader(ComponentType type, Display stringsToDisplay, FileFormat fileFormat) {
        this.type = type;
        this.stringsToDisplay = stringsToDisplay;
        this.fileFormat = fileFormat;
    }

    @Override
    public void drawU(UGraphic ug, Area area, Context2D context) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        UmlCharArea charArea = ((UGraphicTxt)ug).getCharArea();
        int width = (int)dimensionToUse.getWidth();
        int height = (int)dimensionToUse.getHeight();
        String text = this.stringsToDisplay.get(0).toString();
        if (this.fileFormat == FileFormat.UTXT) {
            charArea.drawHLine('\u2550', 0, 1, width - 1, '\u2502', '\u256a');
            charArea.drawStringLR(StringUtils.goUpperCase(text) + "  /", 2, 1);
            charArea.drawHLine('\u2500', 2, 1, text.length() + 4);
            charArea.drawVLine('\u2551', 0, 1, height - 1);
            charArea.drawVLine('\u2551', width - 1, 1, height - 1);
            charArea.drawChar('\u255f', 0, 2);
            charArea.drawStringTB("\u2564\u2502\u2518", text.length() + 4, 0);
            charArea.drawChar('\u2554', 0, 0);
            charArea.drawChar('\u2557', width - 1, 0);
            charArea.drawHLine('\u2550', height - 1, 1, width - 1, '\u2502', '\u256a');
            charArea.drawChar('\u255a', 0, height - 1);
            charArea.drawChar('\u255d', width - 1, height - 1);
        } else {
            charArea.drawHLine('_', 0, 0, width - 1);
            charArea.drawStringLR(StringUtils.goUpperCase(text) + "  /", 2, 1);
            charArea.drawHLine('_', 2, 1, text.length() + 3);
            charArea.drawChar('/', text.length() + 3, 2);
            charArea.drawVLine('!', 0, 1, height);
            charArea.drawVLine('!', width - 1, 1, height);
            charArea.drawHLine('~', height - 1, 1, width - 1);
        }
        if (this.stringsToDisplay.size() > 1 && this.stringsToDisplay.get(1) != null) {
            String comment = this.stringsToDisplay.get(1).toString();
            charArea.drawStringLR(comment, text.length() + 7, 1);
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return StringUtils.getHeight(this.stringsToDisplay) + 1;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return StringUtils.getWcWidth(this.stringsToDisplay) + 2;
    }
}

