/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.command;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.Parser;
import znaishaded.net.sourceforge.plantuml.creole.command.Command;
import znaishaded.net.sourceforge.plantuml.creole.legacy.StripeSimple;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class CommandCreoleOpenIcon
implements Command {
    private final Pattern2 pattern;
    private final HColorSet colorSet;

    private CommandCreoleOpenIcon(HColorSet colorSet, String p) {
        this.pattern = MyPattern.cmpile(p);
        this.colorSet = colorSet;
    }

    public static Command create(HColorSet colorSet) {
        return new CommandCreoleOpenIcon(colorSet, "^(?i)(\\<&([-\\w]+)([\\{,]?(?:(?:scale=|\\*)[0-9.]+)?(?:,color[= :](?:#[0-9a-fA-F]{6}|\\w+))?\\}?)?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            return 0;
        }
        return m3.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m3 = this.pattern.matcher(line);
        if (!m3.find()) {
            throw new IllegalStateException();
        }
        String src = m3.group(2);
        double scale = Parser.getScale(m3.group(3), 1.0);
        String colorName = Parser.getColor(m3.group(3));
        HColor color = null;
        if (colorName != null) {
            color = this.colorSet.getColorIfValid(colorName);
        }
        stripe.addOpenIcon(src, scale, color);
        return line.substring(m3.group(1).length());
    }
}

