/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole.rosetta;

import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBuilder;
import znaishaded.net.sourceforge.plantuml.creole.rosetta.Rosetta;
import znaishaded.net.sourceforge.plantuml.creole.rosetta.StripeRow;
import znaishaded.net.sourceforge.plantuml.creole.rosetta.WikiLanguage;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;

public class CreoleParser2
implements SheetBuilder {
    private final FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final HorizontalAlignment horizontalAlignment;
    private final CreoleMode creoleMode;
    private final FontConfiguration stereotype;

    public CreoleParser2(FontConfiguration fontConfiguration, HorizontalAlignment horizontalAlignment, ISkinSimple skinParam, CreoleMode creoleMode, FontConfiguration stereotype) {
        this.stereotype = stereotype;
        this.creoleMode = creoleMode;
        this.fontConfiguration = fontConfiguration;
        this.skinParam = skinParam;
        if (skinParam == null) {
            throw new IllegalArgumentException();
        }
        this.horizontalAlignment = horizontalAlignment;
    }

    @Override
    public Sheet createSheet(Display display) {
        Sheet sheet = new Sheet(this.horizontalAlignment);
        if (!display.isWhite()) {
            Rosetta rosetta = Rosetta.fromSyntax(WikiLanguage.CREOLE, display);
            for (String cs : rosetta.translateTo(WikiLanguage.UNICODE)) {
                StripeRow row = StripeRow.parseUnicode(cs, this.fontConfiguration);
                sheet.add(row);
            }
        }
        return sheet;
    }
}

