/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.cute;

import znaishaded.net.sourceforge.plantuml.cute.CuteShape;
import znaishaded.net.sourceforge.plantuml.cute.Group;
import znaishaded.net.sourceforge.plantuml.cute.Positionned;
import znaishaded.net.sourceforge.plantuml.cute.RotationZoom;
import znaishaded.net.sourceforge.plantuml.cute.VarArgs;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PositionnedImpl
implements Positionned {
    private final CuteShape cuteShape;
    private final HColor color;
    private final UTranslate position;
    private final RotationZoom rotationZoom;

    public String toString() {
        return "Positionned " + this.position + " " + this.cuteShape;
    }

    public PositionnedImpl(CuteShape cuteShape, VarArgs args) {
        this.cuteShape = cuteShape;
        this.color = args.getAsColor("color");
        this.position = args.getPosition();
        this.rotationZoom = RotationZoom.fromVarArgs(args);
    }

    private PositionnedImpl(CuteShape cuteShape, HColor color, UTranslate position, RotationZoom rotationZoom) {
        this.cuteShape = cuteShape;
        this.color = color;
        this.position = position;
        this.rotationZoom = rotationZoom;
    }

    public PositionnedImpl(Group group, RotationZoom rotation) {
        this.cuteShape = group;
        this.color = HColorUtils.BLACK;
        this.position = new UTranslate();
        this.rotationZoom = rotation;
    }

    public PositionnedImpl(Group group, UTranslate translation) {
        this.cuteShape = group;
        this.color = HColorUtils.BLACK;
        this.position = translation;
        this.rotationZoom = RotationZoom.none();
    }

    private UGraphic applyColor(UGraphic ug) {
        return ug.apply(this.color.bg()).apply(this.color);
    }

    @Override
    public void drawU(UGraphic ug) {
        ug = this.applyColor(ug);
        ug = ug.apply(this.position);
        CuteShape tmp = this.rotationZoom.isNone() ? this.cuteShape : this.cuteShape.rotateZoom(this.rotationZoom);
        tmp.drawU(ug);
    }

    @Override
    public Positionned rotateZoom(RotationZoom other) {
        return new PositionnedImpl(this.cuteShape, this.color, other.getUTranslate(this.position), this.rotationZoom.compose(other));
    }

    @Override
    public Positionned translate(UTranslate other) {
        return new PositionnedImpl(this.cuteShape, this.color, this.position.compose(other), this.rotationZoom);
    }
}

