/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.directdot;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import znaishaded.net.sourceforge.plantuml.AbstractPSystem;
import znaishaded.net.sourceforge.plantuml.CounterOutputStream;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.api.ImageDataSimple;
import znaishaded.net.sourceforge.plantuml.core.DiagramDescription;
import znaishaded.net.sourceforge.plantuml.core.ImageData;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ExeState;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.ProcessState;
import znaishaded.net.sourceforge.plantuml.graphic.GraphicStrings;
import znaishaded.net.sourceforge.plantuml.svek.IEntityImage;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import znaishaded.net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class PSystemDot
extends AbstractPSystem {
    private final String data;

    public PSystemDot(String data) {
        this.data = data;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Dot)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        Graphviz graphviz = GraphvizUtils.create(null, this.data, StringUtils.goLowerCase(fileFormat.getFileFormat().name()));
        if (graphviz.getExeState() != ExeState.OK) {
            IEntityImage result = GraphicStrings.createForError(Arrays.asList("There is an issue with your Dot/Graphviz installation"), false);
            UGraphicUtils.writeImage(os, null, fileFormat, this.seed(), new ColorMapperIdentity(), HColorUtils.WHITE, result);
            return ImageDataSimple.error();
        }
        CounterOutputStream counter = new CounterOutputStream(os);
        ProcessState state = graphviz.createFile3(counter);
        if (counter.getLength() == 0 || state.differs(ProcessState.TERMINATED_OK())) {
            IEntityImage result = GraphicStrings.createForError(Arrays.asList("GraphViz has crashed"), false);
            UGraphicUtils.writeImage(os, null, fileFormat, this.seed(), new ColorMapperIdentity(), HColorUtils.WHITE, result);
            return ImageDataSimple.error();
        }
        return ImageDataSimple.ok();
    }
}

