/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.stats;

import java.util.Date;
import java.util.EnumMap;
import java.util.Map;
import java.util.TreeSet;
import znaishaded.net.sourceforge.plantuml.api.NumberAnalyzed;
import znaishaded.net.sourceforge.plantuml.stats.FormatCounter;
import znaishaded.net.sourceforge.plantuml.stats.HistoricalData;
import znaishaded.net.sourceforge.plantuml.stats.HumanDuration;
import znaishaded.net.sourceforge.plantuml.stats.ParsedGenerated;
import znaishaded.net.sourceforge.plantuml.stats.StatsLineImpl;
import znaishaded.net.sourceforge.plantuml.stats.StatsTableImpl;
import znaishaded.net.sourceforge.plantuml.stats.api.Stats;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsColumn;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsLine;
import znaishaded.net.sourceforge.plantuml.stats.api.StatsTable;

public class StatsImpl
implements Stats {
    private final FormatCounter formatCounterCurrent;
    private final FormatCounter formatCounterEver;
    private final Map<String, ParsedGenerated> byTypeEver;
    private final Map<String, ParsedGenerated> byTypeCurrent;
    private final ParsedGenerated fullEver;
    private final HistoricalData historicalData;

    StatsImpl(Map<String, ParsedGenerated> byTypeEver, Map<String, ParsedGenerated> byTypeCurrent, FormatCounter formatCounterCurrent, FormatCounter formatCounterEver, HistoricalData historicalData, ParsedGenerated fullEver) {
        this.byTypeEver = byTypeEver;
        this.byTypeCurrent = byTypeCurrent;
        this.formatCounterCurrent = formatCounterCurrent;
        this.formatCounterEver = formatCounterEver;
        this.fullEver = fullEver;
        this.historicalData = historicalData;
    }

    private StatsLine createDataLineSession(ParsedGenerated data) {
        EnumMap<StatsColumn, Object> result = new EnumMap<StatsColumn, Object>(StatsColumn.class);
        long id = data.getId();
        if (id != -1L) {
            result.put(StatsColumn.SESSION_ID, Long.valueOf(id));
        }
        result.put(StatsColumn.VERSION, data.getVersion());
        long creationTime = data.parsedDated().getCreationTime();
        long modificationTime = data.parsedDated().getModificationTime();
        result.put(StatsColumn.STARTING, new Date(creationTime));
        result.put(StatsColumn.LAST, new Date(modificationTime));
        result.put(StatsColumn.DURATION_STRING, new HumanDuration(modificationTime - creationTime));
        result.put(StatsColumn.PARSED_COUNT, Long.valueOf(data.parsedDated().getNb()));
        result.put(StatsColumn.PARSED_MEAN_TIME, Long.valueOf(data.parsedDated().getMean()));
        result.put(StatsColumn.PARSED_STANDARD_DEVIATION, Long.valueOf(data.parsedDated().getStandardDeviation()));
        result.put(StatsColumn.PARSED_MAX_TIME, Long.valueOf(data.parsedDated().getMax()));
        result.put(StatsColumn.GENERATED_COUNT, Long.valueOf(data.generatedDated().getNb()));
        result.put(StatsColumn.GENERATED_MEAN_TIME, Long.valueOf(data.generatedDated().getMean()));
        result.put(StatsColumn.GENERATED_STANDARD_DEVIATION, Long.valueOf(data.generatedDated().getStandardDeviation()));
        result.put(StatsColumn.GENERATED_MAX_TIME, Long.valueOf(data.generatedDated().getMax()));
        return new StatsLineImpl(result);
    }

    private StatsLine createLineByDiagramType(String key, NumberAnalyzed parse, NumberAnalyzed generate) {
        EnumMap<StatsColumn, Object> result = new EnumMap<StatsColumn, Object>(StatsColumn.class);
        result.put(StatsColumn.DIAGRAM_TYPE, key);
        result.put(StatsColumn.PARSED_COUNT, Long.valueOf(parse.getNb()));
        result.put(StatsColumn.PARSED_MEAN_TIME, Long.valueOf(parse.getMean()));
        result.put(StatsColumn.PARSED_STANDARD_DEVIATION, Long.valueOf(parse.getStandardDeviation()));
        result.put(StatsColumn.PARSED_MAX_TIME, Long.valueOf(parse.getMax()));
        result.put(StatsColumn.GENERATED_COUNT, Long.valueOf(generate.getNb()));
        result.put(StatsColumn.GENERATED_MEAN_TIME, Long.valueOf(generate.getMean()));
        result.put(StatsColumn.GENERATED_STANDARD_DEVIATION, Long.valueOf(generate.getStandardDeviation()));
        result.put(StatsColumn.GENERATED_MAX_TIME, Long.valueOf(generate.getMax()));
        return new StatsLineImpl(result);
    }

    @Override
    public StatsTable getLastSessions() {
        StatsTableImpl result = new StatsTableImpl("Statistics");
        for (ParsedGenerated histo : this.historicalData.getHistorical()) {
            result.addLine(this.createDataLineSession(histo));
        }
        if (this.historicalData.current() != null) {
            result.addLine(this.createDataLineSession(this.historicalData.current()));
        }
        result.addLine(this.createDataLineSession(this.fullEver));
        return result;
    }

    @Override
    public StatsTable getCurrentSessionByFormat() {
        return this.formatCounterCurrent.getStatsTable("current format");
    }

    @Override
    public StatsTable getAllByFormat() {
        return this.formatCounterEver.getStatsTable("all format");
    }

    @Override
    public StatsTable getCurrentSessionByDiagramType() {
        return this.getByDiagramType("Current session", this.byTypeCurrent);
    }

    @Override
    public StatsTable getAllByDiagramType() {
        return this.getByDiagramType("All session", this.byTypeEver);
    }

    private StatsTable getByDiagramType(String name, Map<String, ParsedGenerated> data) {
        StatsTableImpl result = new StatsTableImpl(name);
        TreeSet<String> keys = new TreeSet<String>(data.keySet());
        NumberAnalyzed totalParsing = new NumberAnalyzed();
        NumberAnalyzed totalGenerating = new NumberAnalyzed();
        for (String key : keys) {
            NumberAnalyzed parse = data.get(key).parsed();
            NumberAnalyzed generate = data.get(key).generated();
            totalParsing.add(parse);
            totalGenerating.add(generate);
            result.addLine(this.createLineByDiagramType(key, parse, generate));
        }
        result.addLine(this.createLineByDiagramType("Total", totalParsing, totalGenerating));
        return result;
    }
}

